/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw.data;

import de.mossgrabers.framework.daw.data.IDevice;
import de.mossgrabers.reaper.communication.Processor;
import de.mossgrabers.reaper.framework.daw.DataSetupEx;
import de.mossgrabers.reaper.framework.daw.data.ItemImpl;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DeviceImpl
extends ItemImpl
implements IDevice {
    private static final Pattern PATTERN_DEVICE_NAME = Pattern.compile("(.+:)?\\s*(.+?)\\s*(\\(.+\\))?");
    private boolean isEnabled = false;

    public DeviceImpl(DataSetupEx dataSetup, int index) {
        super(dataSetup, index);
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void toggleEnabledState() {
        this.sendOSC(this.getIndex() + 1 + "/bypass", this.isEnabled);
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    @Override
    public void setName(String name) {
        super.setInternalName(DeviceImpl.removeTypeAndManufacturer(name));
    }

    @Override
    public void select() {
        this.sendOSC("selected", this.getIndex() + 1);
    }

    @Override
    public void remove() {
        this.sendDeviceOSC("remove");
    }

    @Override
    public void duplicate() {
        this.sendDeviceOSC("duplicate");
    }

    private static String removeTypeAndManufacturer(String name) {
        if (name == null) {
            return "";
        }
        Matcher matcher = PATTERN_DEVICE_NAME.matcher(name);
        if (!matcher.matches()) {
            return name;
        }
        return matcher.group(2);
    }

    protected void sendDeviceOSC(String command) {
        this.sendOSC(this.getIndex() + 1 + "/" + command);
    }

    @Override
    protected Processor getProcessor() {
        return Processor.DEVICE;
    }
}

