/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.trigger.track;

import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.utils.ButtonEvent;
import java.util.Optional;

public class SoloCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractTriggerCommand<S, C> {
    private int index;

    public SoloCommand(IModel model, S surface) {
        this(-1, model, surface);
    }

    public SoloCommand(int index, IModel model, S surface) {
        super(model, surface);
        this.index = index;
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        ITrackBank currentTrackBank = this.model.getCurrentTrackBank();
        if (this.index == -1) {
            Optional selectedItem = currentTrackBank.getSelectedItem();
            if (selectedItem.isPresent()) {
                ((ITrack)selectedItem.get()).toggleSolo();
            }
        } else {
            ((ITrack)currentTrackBank.getItem(this.index)).toggleSolo();
        }
    }

    @Override
    public void executeShifted(ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        ITrackBank currentTrackBank = this.model.getCurrentTrackBank();
        if (this.index == -1) {
            Optional selectedItem = currentTrackBank.getSelectedItem();
            if (selectedItem.isPresent()) {
                ((ITrack)selectedItem.get()).toggleAutoMonitor();
            }
        } else {
            ((ITrack)currentTrackBank.getItem(this.index)).toggleAutoMonitor();
        }
    }
}

