/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.trigger.clip;

import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.utils.ButtonEvent;

public class DoubleCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractTriggerCommand<S, C> {
    private final boolean onShift;

    public DoubleCommand(IModel model, S surface) {
        this(model, surface, false);
    }

    public DoubleCommand(IModel model, S surface, boolean onShift) {
        super(model, surface);
        this.onShift = onShift;
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (event == ButtonEvent.DOWN && !this.onShift) {
            this.doubleClip();
        }
    }

    @Override
    public void executeShifted(ButtonEvent event) {
        if (event == ButtonEvent.DOWN && this.onShift) {
            this.doubleClip();
        }
    }

    protected void doubleClip() {
        INoteClip clip = this.model.getCursorClip();
        if (clip.doesExist()) {
            clip.duplicateContent();
        }
    }
}

