/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchpad.definition;

import de.mossgrabers.controller.novation.launchpad.controller.LaunchpadControlSurface;
import de.mossgrabers.controller.novation.launchpad.definition.AbstractLaunchpadDefinition;
import de.mossgrabers.controller.novation.launchpad.definition.button.LaunchpadButton;
import de.mossgrabers.framework.controller.grid.LightInfo;
import de.mossgrabers.framework.utils.OperatingSystem;
import de.mossgrabers.framework.utils.Pair;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class LaunchpadProControllerDefinition
extends AbstractLaunchpadDefinition {
    private static final UUID EXTENSION_ID = UUID.fromString("80B63970-64F1-11E5-A837-0800200C9A66");
    private static final String SYSEX_HEADER = "F0 00 20 29 02 10 ";

    public LaunchpadProControllerDefinition() {
        super(EXTENSION_ID, "Launchpad Pro");
        this.buttonSetup.setButton(LaunchpadButton.SHIFT, 80);
        this.buttonSetup.setButton(LaunchpadButton.USER, 98);
        this.buttonSetup.setButton(LaunchpadButton.CLICK, 70);
        this.buttonSetup.setButton(LaunchpadButton.UNDO, 60);
        this.buttonSetup.setButton(LaunchpadButton.DELETE, 50);
        this.buttonSetup.setButton(LaunchpadButton.QUANTIZE, 40);
        this.buttonSetup.setButton(LaunchpadButton.DUPLICATE, 30);
        this.buttonSetup.setButton(LaunchpadButton.PLAY, 20);
        this.buttonSetup.setButton(LaunchpadButton.RECORD, 10);
        this.buttonSetup.setButton(LaunchpadButton.REC_ARM, 1);
        this.buttonSetup.setButton(LaunchpadButton.TRACK_SELECT, 2);
        this.buttonSetup.setButton(LaunchpadButton.MUTE, 3);
        this.buttonSetup.setButton(LaunchpadButton.SOLO, 4);
        this.buttonSetup.setButton(LaunchpadButton.VOLUME, 5);
        this.buttonSetup.setButton(LaunchpadButton.PAN, 6);
        this.buttonSetup.setButton(LaunchpadButton.SENDS, 7);
        this.buttonSetup.setButton(LaunchpadButton.STOP_CLIP, 8);
    }

    @Override
    public List<Pair<String[], String[]>> getMidiDiscoveryPairs(OperatingSystem os) {
        List<Pair<String[], String[]>> midiDiscoveryPairs = super.getMidiDiscoveryPairs(os);
        switch (os) {
            case WINDOWS: {
                midiDiscoveryPairs.addAll(this.createWindowsDeviceDiscoveryPairs("MIDIIN2 (%sLaunchpad Pro)", "MIDIOUT2 (%sLaunchpad Pro)"));
                break;
            }
            case LINUX: {
                midiDiscoveryPairs.add(this.addDeviceDiscoveryPair("Launchpad Pro MIDI 2", "Launchpad Pro MIDI 2"));
                midiDiscoveryPairs.add(this.addDeviceDiscoveryPair("Launchpad Pro Standalone Port", "Launchpad Pro Standalone Port"));
                break;
            }
            case MAC: 
            case MAC_ARM: {
                midiDiscoveryPairs.add(this.addDeviceDiscoveryPair("Launchpad Pro Standalone Port", "Launchpad Pro Standalone Port"));
                break;
            }
        }
        return midiDiscoveryPairs;
    }

    @Override
    public boolean isPro() {
        return true;
    }

    @Override
    public String getSysExHeader() {
        return SYSEX_HEADER;
    }

    @Override
    public String getStandaloneModeCommand() {
        return "21 01";
    }

    @Override
    public String getProgramModeCommand() {
        return "2C 03";
    }

    @Override
    public void resetMode(LaunchpadControlSurface surface) {
        surface.sendLaunchpadSysEx("2C 00");
    }

    @Override
    public void setLogoColor(LaunchpadControlSurface surface, int color) {
        surface.sendLaunchpadSysEx("0A 63 " + StringUtils.toHexStr(color));
    }

    @Override
    public boolean sceneButtonsUseCC() {
        return true;
    }

    @Override
    public List<String> buildLEDUpdate(Map<Integer, LightInfo> padInfos) {
        StringBuilder sbNormal = new StringBuilder();
        StringBuilder sbFlash = new StringBuilder();
        StringBuilder sbPulse = new StringBuilder();
        for (Map.Entry<Integer, LightInfo> e : padInfos.entrySet()) {
            int note = e.getKey();
            LightInfo info = e.getValue();
            sbNormal.append(StringUtils.toHexStr(note)).append(' ').append(StringUtils.toHexStr(info.getColor())).append(' ');
            if (info.getBlinkColor() <= 0) continue;
            if (info.isFast()) {
                sbFlash.append(StringUtils.toHexStr(note)).append(' ').append(StringUtils.toHexStr(info.getBlinkColor())).append(' ');
                continue;
            }
            sbPulse.append(StringUtils.toHexStr(note)).append(' ').append(StringUtils.toHexStr(info.getBlinkColor())).append(' ');
        }
        ArrayList<String> result = new ArrayList<String>(3);
        String sysExHeader = this.getSysExHeader();
        if (sbNormal.length() > 0) {
            result.add(sysExHeader + "0A " + sbNormal + "F7");
        }
        if (sbFlash.length() > 0) {
            result.add(sysExHeader + "23 " + sbFlash + "F7");
        }
        if (sbPulse.length() > 0) {
            result.add(sysExHeader + "28 " + sbPulse + "F7");
        }
        return result;
    }
}

