/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.jam;

import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.configuration.IEnumSetting;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.constants.Capability;
import de.mossgrabers.framework.daw.midi.ArpeggiatorMode;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.view.Views;
import java.util.List;

public class MaschineJamConfiguration
extends AbstractConfiguration {
    private static final Views[] STARTUP_VIEWS = new Views[]{Views.PLAY, Views.CHORDS, Views.PIANO, Views.DRUM64, Views.DRUM, Views.DRUM4, Views.DRUM8, Views.SEQUENCER, Views.RAINDROPS, Views.POLY_SEQUENCER};
    private static final Modes[] STARTUP_MODES = new Modes[]{Modes.VOLUME, Modes.PAN, Modes.TRACK, Modes.SEND1, Modes.SEND2, Modes.SEND3, Modes.SEND4, Modes.SEND5, Modes.SEND6, Modes.SEND7, Modes.SEND8, Modes.DEVICE_PARAMS, Modes.USER};
    private IEnumSetting slowFaderChangeSetting;
    private boolean slowFaderChange;

    public MaschineJamConfiguration(IHost host, IValueChanger valueChanger, List<ArpeggiatorMode> arpeggiatorModes) {
        super(host, valueChanger, arpeggiatorModes);
    }

    @Override
    public void init(ISettingsUI globalSettings, ISettingsUI documentSettings) {
        this.activateScaleSetting(documentSettings);
        this.activateScaleBaseSetting(documentSettings);
        this.activateScaleInScaleSetting(documentSettings);
        this.activateScaleLayoutSetting(documentSettings);
        this.activateNoteRepeatSetting(documentSettings);
        this.activateRecordButtonSetting(globalSettings);
        this.activateShiftedRecordButtonSetting(globalSettings);
        this.activateBehaviourOnPauseSetting(globalSettings);
        this.activateAccentActiveSetting(globalSettings);
        this.activateAccentValueSetting(globalSettings);
        this.activateQuantizeAmountSetting(globalSettings);
        this.activateStartupViewSetting(globalSettings, STARTUP_VIEWS);
        this.activateStartWithSessionViewSetting(globalSettings);
        this.activateTurnOffScalePadsSetting(globalSettings);
        this.activateShowPlayedChordsSetting(globalSettings);
        if (this.host.supports(Capability.HAS_DRUM_DEVICE)) {
            this.activateTurnOffEmptyDrumPadsSetting(globalSettings);
        }
        this.activateSelectClipOnLaunchSetting(globalSettings);
        this.activateActionForRecArmedPad(globalSettings);
        this.activateDrawRecordStripeSetting(globalSettings);
        this.activateFlipSessionSetting(globalSettings);
        this.activateExcludeDeactivatedItemsSetting(globalSettings);
        this.activateSlowFaderChangeSetting(globalSettings);
        this.activateStartupModeSetting(globalSettings, STARTUP_MODES);
        this.activateNewClipLengthSetting(globalSettings);
        this.activateKnobSpeedSetting(globalSettings);
        this.activateFootswitchSetting(globalSettings, 0, "Footswitch (Tip)");
        this.activateFootswitchSetting(globalSettings, 1, "Footswitch (Ring)");
    }

    protected void activateSlowFaderChangeSetting(ISettingsUI settingsUI) {
        this.slowFaderChangeSetting = settingsUI.getEnumSetting("Slow Fader Change", "Workflow", ON_OFF_OPTIONS, ON_OFF_OPTIONS[0]);
        this.slowFaderChangeSetting.addValueObserver(value -> {
            this.slowFaderChange = "On".equals(value);
        });
    }

    public boolean isSlowFaderChange() {
        return this.slowFaderChange;
    }

    public void toggleSlowFaderChange() {
        this.slowFaderChangeSetting.set(ON_OFF_OPTIONS[this.slowFaderChange ? 0 : 1]);
    }
}

