/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.kontrol.mkii.mode;

import de.mossgrabers.controller.ni.kontrol.mkii.KontrolProtocolConfiguration;
import de.mossgrabers.controller.ni.kontrol.mkii.TrackType;
import de.mossgrabers.controller.ni.kontrol.mkii.controller.KontrolProtocolControlSurface;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.constants.DeviceID;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.daw.data.ICursorLayer;
import de.mossgrabers.framework.daw.data.IDevice;
import de.mossgrabers.framework.daw.data.ILayer;
import de.mossgrabers.framework.daw.data.ISpecificDevice;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.IDeviceBank;
import de.mossgrabers.framework.daw.data.bank.ILayerBank;
import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.daw.data.bank.IParameterPageBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.featuregroup.AbstractParameterMode;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameterprovider.IParameterProvider;
import de.mossgrabers.framework.parameterprovider.device.BankParameterProvider;
import de.mossgrabers.framework.parameterprovider.device.SelectedLayerDeviceBankParameterProvider;
import de.mossgrabers.framework.utils.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ParamsMode
extends AbstractParameterMode<KontrolProtocolControlSurface, KontrolProtocolConfiguration, IParameter> {
    private static final String[] BANK_NAMES = new String[]{"Cursor Device ", "Track ", "Project ", "Layer"};
    private static final int LAYER_INDEX = 3;
    private final List<IParameterBank> banks = new ArrayList<IParameterBank>(4);
    private final IParameterProvider[] providers = new IParameterProvider[4];
    private int activeProviderIndex = 0;
    private boolean layerSubModeEnabled = false;
    private int previouslySelectedDevice = -1;
    private long previouslyDeviceChange = System.currentTimeMillis();
    private int currentlySelectedDevice = -1;
    private String currentChainInfo = "";

    public ParamsMode(KontrolProtocolControlSurface surface, IModel model, List<ContinuousID> controls) {
        super("Parameters", surface, model, false);
        this.setControls(controls);
        this.banks.add(model.getCursorDevice().getParameterBank());
        this.banks.add(model.getCursorTrack().getParameterBank());
        this.banks.add(model.getProject().getParameterBank());
        for (int i = 0; i < this.banks.size(); ++i) {
            this.providers[i] = new BankParameterProvider(this.banks.get(i));
        }
        SelectedLayerDeviceBankParameterProvider provider = new SelectedLayerDeviceBankParameterProvider(model.getCursorLayer(), model.getCursorDevice().getParameterBank().getPageSize());
        this.providers[3] = provider;
        this.providers[3].addParametersObserver(() -> {
            this.banks.set(3, provider.getBank());
            if (this.layerSubModeEnabled) {
                this.selectProvider(3);
            }
        });
        this.banks.add(provider.getBank());
        this.selectProvider(0);
    }

    public void enableLayerSubMode(boolean enable) {
        this.layerSubModeEnabled = enable;
        this.selectProvider(enable ? 3 : 0);
    }

    public void selectNextMode() {
        this.selectProvider((this.activeProviderIndex + 1) % 3);
    }

    @Override
    public int getKnobValue(int index) {
        IValueChanger valueChanger = this.model.getValueChanger();
        IParameterBank parameterBank = this.banks.get(this.activeProviderIndex);
        if (index >= 112 && index < 120) {
            IParameter parameter = (IParameter)parameterBank.getItem(index - 112);
            return valueChanger.toMidiValue(parameter.getValue());
        }
        return 0;
    }

    @Override
    public void updateDisplay() {
        ICursorLayer cursorLayer = this.model.getCursorLayer();
        if (this.layerSubModeEnabled) {
            ILayerBank layerBank = cursorLayer.getLayerBank();
            if (layerBank.getSelectedItem().isEmpty()) {
                ((ILayer)layerBank.getItem(0)).select();
            }
            for (int i = 0; i < layerBank.getPageSize(); ++i) {
                ILayer layer = (ILayer)layerBank.getItem(i);
                ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(64, TrackType.toTrackType(layer.getType()), i);
                ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(66, layer.isSelected() ? 1 : 0, i);
                String layerName = "Layer " + (layer.getPosition() + 1) + ": " + layer.getName();
                ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(72, 0, i, layerName);
            }
        } else {
            ITrackBank trackBank = this.model.getTrackBank();
            for (int i = 0; i < trackBank.getPageSize(); ++i) {
                ITrack track = (ITrack)trackBank.getItem(i);
                ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(64, TrackType.toTrackType(track.getType()), i);
                ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(66, track.isSelected() ? 1 : 0, i);
                ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(72, 0, i, track.getName());
            }
        }
        ((KontrolProtocolControlSurface)this.surface).sendGlobalValues(this.model);
    }

    private Pair<Integer, String> getSelectedDeviceInfo() {
        Optional selectedDevice;
        String presetName;
        if (this.layerSubModeEnabled) {
            ICursorLayer cursorLayer = this.model.getCursorLayer();
            Optional<ISpecificDevice> selectedSpecificDevice = cursorLayer.getSelectedDevice();
            presetName = selectedSpecificDevice.isPresent() ? selectedSpecificDevice.get().getPresetName() : "none";
            selectedDevice = selectedSpecificDevice.isPresent() ? Optional.of((IDevice)selectedSpecificDevice.get()) : Optional.empty();
        } else {
            ICursorDevice cursorDevice = this.model.getCursorDevice();
            IDeviceBank deviceBank = cursorDevice.getDeviceBank();
            presetName = cursorDevice.getPresetName();
            selectedDevice = deviceBank.getSelectedItem();
        }
        int deviceIndex = selectedDevice.isPresent() ? ((IDevice)selectedDevice.get()).getIndex() : 0;
        return new Pair<Integer, String>(deviceIndex, presetName);
    }

    @Override
    public void selectPreviousItem() {
        this.model.getCursorDevice().selectPrevious();
    }

    @Override
    public void selectNextItem() {
        this.model.getCursorDevice().selectNext();
    }

    @Override
    public void selectPreviousItemPage() {
        this.banks.get(this.activeProviderIndex).scrollBackwards();
    }

    @Override
    public void selectNextItemPage() {
        this.banks.get(this.activeProviderIndex).scrollForwards();
    }

    private void selectProvider(int index) {
        this.activeProviderIndex = Math.clamp((long)index, 0, 3);
        IParameterBank parameterBank = this.banks.get(this.activeProviderIndex);
        this.switchBanks(parameterBank);
        this.setParameterProvider(this.providers[this.activeProviderIndex]);
        this.bindControls();
        this.mvHelper.notifySelectedParameterPage(parameterBank, BANK_NAMES[this.activeProviderIndex]);
    }

    public void selectedDeviceHasChanged(int deviceIndex) {
        IDeviceBank deviceBank;
        if (this.layerSubModeEnabled) {
            deviceBank = this.model.getCursorLayer().getDeviceBank();
        } else {
            ICursorDevice cursorDevice = this.model.getCursorDevice();
            if (!cursorDevice.doesExist()) {
                return;
            }
            deviceBank = cursorDevice.getDeviceBank();
        }
        IDevice item = (IDevice)deviceBank.getItem(deviceIndex);
        if (item.doesExist()) {
            item.select();
            if (this.layerSubModeEnabled) {
                ((KontrolProtocolControlSurface)this.surface).getHost().scheduleTask(() -> {
                    ((SelectedLayerDeviceBankParameterProvider)this.providers[3]).configureCurrentBank();
                    this.banks.set(3, ((SelectedLayerDeviceBankParameterProvider)this.providers[3]).getBank());
                }, 100L);
            }
        }
    }

    public boolean isLayerSubModeEnabled() {
        return this.layerSubModeEnabled;
    }

    public void updateAvailableDevices() {
        boolean respectCache;
        String presetName = "";
        StringBuilder chainInfoSb = new StringBuilder();
        int deviceIndex = 0;
        if (this.isTrackOrProjectMode()) {
            chainInfoSb.append(this.activeProviderIndex == 1 ? "Track\u0000" : "Project\u0000");
        } else {
            IDevice device;
            Pair<Integer, String> pair = this.getSelectedDeviceInfo();
            deviceIndex = pair.getKey();
            presetName = pair.getValue();
            IDeviceBank deviceBank = ((ParamsMode)((KontrolProtocolControlSurface)this.surface).getModeManager().get(Modes.DEVICE_PARAMS)).isLayerSubModeEnabled() ? this.model.getCursorLayer().getDeviceBank() : this.model.getCursorDevice().getDeviceBank();
            for (int i = 0; i < 8 && (device = (IDevice)deviceBank.getItem(i)).doesExist(); ++i) {
                chainInfoSb.append(device.getName()).append('\u0000');
            }
        }
        String chainInfo = chainInfoSb.append('\u0000').toString();
        boolean bl = respectCache = this.currentChainInfo.equals(chainInfo) && this.currentlySelectedDevice == deviceIndex;
        if (this.currentlySelectedDevice != deviceIndex) {
            this.previouslyDeviceChange = System.currentTimeMillis();
            this.previouslySelectedDevice = this.currentlySelectedDevice;
            this.currentlySelectedDevice = deviceIndex;
        } else if (System.currentTimeMillis() - this.previouslyDeviceChange > 1000L) {
            this.previouslySelectedDevice = this.currentlySelectedDevice;
        }
        this.currentChainInfo = chainInfo;
        ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(112, 0, deviceIndex, respectCache);
        IParameterBank parameterBank = this.banks.get(this.activeProviderIndex);
        IParameterPageBank parameterPageBank = parameterBank.getPageBank();
        Optional selectedItem = parameterPageBank.getSelectedItem();
        String selectedPage = selectedItem.isPresent() ? (String)selectedItem.get() : "";
        int selectedPageIndex = Math.max(0, parameterPageBank.getSelectedItemIndex());
        for (int i = 0; i < 8; ++i) {
            IParameter parameter = (IParameter)parameterBank.getItem(i);
            String name = parameter.doesExist() ? parameter.getName() : "";
            String info = parameter.doesExist() ? parameter.getDisplayedValue() : "";
            ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(114, 0, i, name, respectCache);
            ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(115, 0, i, info, respectCache);
        }
        ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(117, 0, 0, selectedPage, respectCache);
        ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(113, 0, 0, chainInfo, respectCache);
        ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(116, parameterPageBank.getItemCount(), selectedPageIndex, respectCache);
        ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(118, 0, 0, presetName, respectCache);
        ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(112, 0, deviceIndex, respectCache);
        ISpecificDevice kkDevice = this.model.getSpecificDevice(DeviceID.NI_KOMPLETE);
        String kompleteInstanceNew = kkDevice.doesExist() ? kkDevice.getID() : "";
        ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(65, 0, 0, kompleteInstanceNew, respectCache);
    }

    public boolean isTrackOrProjectMode() {
        return this.activeProviderIndex == 1 || this.activeProviderIndex == 2;
    }

    public int getPreviouslySelectedDevice() {
        return this.previouslySelectedDevice;
    }
}

