/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.kontrol.mki.controller;

import de.mossgrabers.controller.ni.kontrol.mki.Kontrol1Configuration;
import de.mossgrabers.controller.ni.kontrol.mki.controller.Kontrol1UsbDevice;
import de.mossgrabers.framework.controller.display.AbstractTextDisplay;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.utils.StringUtils;

public class Kontrol1Display
extends AbstractTextDisplay {
    private final int maxParameterValue;
    private final Kontrol1UsbDevice usbDevice;

    public Kontrol1Display(IHost host, int maxParameterValue, Kontrol1Configuration configuration, Kontrol1UsbDevice usbDevice) {
        super(host, null, 2, 9, 72);
        this.maxParameterValue = maxParameterValue;
        this.usbDevice = usbDevice;
    }

    @Override
    public void shutdown() {
        this.usbDevice.shutdown();
    }

    @Override
    public void flush() {
        super.flush();
        this.usbDevice.sendDisplayData();
    }

    @Override
    public ITextDisplay clear() {
        for (int i = 0; i < 9; ++i) {
            this.usbDevice.setBar(i, false, 0, 1);
            for (int j = 0; j < 7; ++j) {
                this.usbDevice.setDot(0, j, false);
                this.usbDevice.setDot(1, j, false);
            }
        }
        return super.clear();
    }

    @Override
    public ITextDisplay setBlock(int row, int block, String value) {
        int cell = 2 * block;
        if (value.length() > 9) {
            this.cells[row * this.noOfCells + cell] = value.substring(0, 9);
            this.cells[row * this.noOfCells + cell + 1] = StringUtils.pad(value.substring(9), 8);
        } else {
            this.cells[row * this.noOfCells + cell] = StringUtils.pad(value, 9);
            this.clearCell(row, cell + 1);
        }
        return this;
    }

    @Override
    public void writeLine(int row, String text, String previousText) {
        Object t = text;
        for (int i = 0; i < ((String)t).length(); ++i) {
            boolean isDot;
            char c = ((String)t).charAt(i);
            boolean bl = isDot = c == '.';
            if (!isDot || i % 8 == 0) {
                this.usbDevice.setDot(row, i, isDot);
                this.usbDevice.setCharacter(row, i, isDot ? (char)' ' : (char)c);
                continue;
            }
            this.usbDevice.setDot(row, i - 1, true);
            this.usbDevice.setDot(row, i, false);
            int end = (i / 8 + 1) * 8;
            t = ((String)t).substring(0, i) + ((String)t).substring(i + 1, end) + " " + ((String)t).substring(end);
            c = ((String)t).charAt(i);
            this.usbDevice.setCharacter(row, i, c == '.' ? (char)' ' : (char)c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBar(int column, boolean hasBorder, int value) {
        Object object = this.notificationLock;
        synchronized (object) {
            if (this.notificationTimeout <= 0) {
                this.usbDevice.setBar(column, hasBorder, value, this.maxParameterValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPanBar(int column, boolean hasBorder, int value) {
        Object object = this.notificationLock;
        synchronized (object) {
            if (this.notificationTimeout <= 0) {
                this.usbDevice.setPanBar(column, hasBorder, value, this.maxParameterValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void notifyOnDisplay(String message) {
        int padLength = (this.noOfCharacters - message.length()) / 2;
        String padding = padLength > 0 ? this.emptyLine.substring(0, padLength) : "";
        this.notificationMessage = (padding + message + padding + "  ").substring(0, this.noOfCharacters);
        Object object = this.notificationLock;
        synchronized (object) {
            boolean isRunning = this.notificationTimeout > 0;
            this.notificationTimeout = 700;
            this.clear();
            this.flush();
            if (!isRunning) {
                Kontrol1Display kontrol1Display = this;
                this.host.scheduleTask(() -> kontrol1Display.watch(), 100L);
            }
        }
    }

    @Override
    protected String convertCharacterset(String text) {
        StringBuilder sb = new StringBuilder(text.length());
        int beginIndex = 0;
        int endIndex = 8;
        for (int i = 0; i < 9; ++i) {
            sb.append(text.substring(beginIndex, endIndex));
            beginIndex += 8;
            endIndex += 8;
            if (i == 8) continue;
            sb.append(' ');
        }
        return sb.toString();
    }
}

