/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.kontrol.mki.controller;

import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.daw.DAWColor;

public class Kontrol1ColorManager
extends ColorManager {
    private static final int DAW_COLOR_START = 100;
    private static final int SCALE_COLOR_OCTAVE = 50;
    private static final int SCALE_COLOR_NOTE = 51;
    private static final int SCALE_COLOR_OUT_OF_SCALE = 52;
    private static final int COLOR_BLACK = 0;
    private static final int COLOR_PLAY = 53;
    private static final int COLOR_RECORD = 54;
    private static final int COLOR_WHITE = 255;

    public Kontrol1ColorManager() {
        this.registerColorIndex("BUTTON_STATE_OFF", 0);
        this.registerColorIndex("BUTTON_STATE_ON", 6);
        this.registerColorIndex("BUTTON_STATE_HI", 255);
        this.registerColorIndex("SCALE_COLOR_OFF", 0);
        this.registerColorIndex("SCALE_COLOR_OCTAVE", 50);
        this.registerColorIndex("SCALE_COLOR_NOTE", 51);
        this.registerColorIndex("SCALE_COLOR_OUT_OF_SCALE", 52);
        this.registerColorIndex("COLOR_PAD_OFF", 0);
        this.registerColorIndex("COLOR_PAD_NO_CONTENT", 0);
        this.registerColorIndex("COLOR_PAD_HAS_CONTENT", 50);
        this.registerColorIndex("COLOR_PAD_PLAY", 53);
        this.registerColorIndex("COLOR_PAD_RECORD", 54);
        this.registerColorIndex("COLOR_PAD_MUTED", 0);
        this.registerColorIndex("COLOR_PAD_SELECTED", 255);
        this.registerColorIndex("PLAY_VIEW_COLOR_OFF", 0);
        this.registerColorIndex("PLAY_VIEW_COLOR_PLAY", 53);
        this.registerColorIndex("PLAY_VIEW_COLOR_RECORD", 54);
        this.registerColorIndex("GRID_COLOR_OFF", 0);
        DAWColor[] values = DAWColor.values();
        for (int i = 0; i < values.length; ++i) {
            this.registerColorIndex(values[i], 100 + i);
        }
    }

    @Override
    public ColorEx getColor(int colorIndex, ButtonID buttonID) {
        if (buttonID == null) {
            if (colorIndex >= 100) {
                return DAWColor.getColorEntry(colorIndex - 100);
            }
            switch (colorIndex) {
                case 50: {
                    return ColorEx.BLUE;
                }
                case 51: {
                    return ColorEx.WHITE;
                }
                case 52: {
                    return ColorEx.BLACK;
                }
                case 53: {
                    return ColorEx.GREEN;
                }
                case 54: {
                    return ColorEx.RED;
                }
            }
            return ColorEx.BLACK;
        }
        switch (buttonID) {
            case PLAY: {
                return colorIndex == 255 ? ColorEx.GREEN : ColorEx.DARK_GREEN;
            }
            case RECORD: {
                return colorIndex == 255 ? ColorEx.RED : ColorEx.DARK_RED;
            }
        }
        return colorIndex == 255 ? ColorEx.WHITE : ColorEx.DARK_GRAY;
    }
}

