/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mackie.mcu.command.trigger;

import de.mossgrabers.controller.mackie.mcu.MCUConfiguration;
import de.mossgrabers.controller.mackie.mcu.command.trigger.SelectCommand;
import de.mossgrabers.controller.mackie.mcu.controller.MCUControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.featuregroup.IMode;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.MasterVolumeMode;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;

public class FaderTouchCommand
extends SelectCommand {
    private static final boolean[] isTrackTouched = new boolean[32];
    private final MasterVolumeMode<MCUControlSurface, MCUConfiguration> masterVolumeMode;

    public FaderTouchCommand(int index, IModel model, MCUControlSurface surface, MasterVolumeMode<MCUControlSurface, MCUConfiguration> masterVolumeMode) {
        super(index, model, surface);
        this.masterVolumeMode = masterVolumeMode;
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        boolean isTouched;
        if (event == ButtonEvent.LONG) {
            return;
        }
        ModeManager modeManager = ((MCUControlSurface)this.surface).getModeManager();
        MCUConfiguration configuration = (MCUConfiguration)((MCUControlSurface)this.surface).getConfiguration();
        boolean bl = isTouched = event == ButtonEvent.DOWN;
        if (this.index == 8) {
            if (this.masterVolumeMode.isControlLastParamActive()) {
                return;
            }
            if (isTouched && configuration.isTouchSelectsChannel()) {
                this.model.getMasterTrack().select();
            }
            ((IMode)modeManager.get(Modes.MASTER)).onKnobTouch(0, isTouched);
            return;
        }
        if (configuration.useFadersAsKnobs()) {
            ((IMode)modeManager.getActive()).onKnobTouch(this.index, isTouched);
            return;
        }
        boolean isLayerMode = Modes.isLayerMode((Modes)((Object)modeManager.getActiveID()));
        if (isTouched && configuration.isTouchSelectsChannel()) {
            IItem item = isLayerMode ? (IItem)this.model.getCursorDevice().getLayerBank().getItem(this.channel) : (IItem)this.getTrackBank().getItem(this.channel);
            item.select();
        }
        Modes volumeMode = isLayerMode ? Modes.DEVICE_LAYER_VOLUME : Modes.VOLUME;
        ((IMode)modeManager.get(volumeMode)).onKnobTouch(this.index, isTouched);
        int pos = ((MCUControlSurface)this.surface).getSurfaceID() * 8 + this.index;
        if (configuration.isTouchChannelVolumeMode()) {
            if (isTouched) {
                if (!FaderTouchCommand.hasTouchedFader()) {
                    if (modeManager.isActive(new Modes[]{volumeMode})) {
                        modeManager.setPreviousID(volumeMode);
                    } else {
                        modeManager.setActive(volumeMode);
                    }
                }
                FaderTouchCommand.setTouchedFader(pos, true);
            } else {
                FaderTouchCommand.setTouchedFader(pos, false);
                if (!FaderTouchCommand.hasTouchedFader()) {
                    modeManager.restore();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasTouchedFader() {
        boolean[] blArray = isTrackTouched;
        synchronized (isTrackTouched) {
            for (boolean element : isTrackTouched) {
                if (!element) continue;
                // ** MonitorExit[var0] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setTouchedFader(int pos, boolean isTouched) {
        boolean[] blArray = isTrackTouched;
        synchronized (isTrackTouched) {
            FaderTouchCommand.isTrackTouched[pos] = isTouched;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

