/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.mode.configuration;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.PushVersion;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.controller.ableton.push.mode.configuration.AbstractConfigurationMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.resource.ChannelType;

public class SetupMode
extends AbstractConfigurationMode {
    public SetupMode(PushControlSurface surface, IModel model) {
        super(1, "Setup", surface, model);
    }

    @Override
    public void onKnobValue(int index, int value) {
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        switch (index) {
            case 1: {
                config.changeDisplayBrightness(value);
                break;
            }
            case 2: {
                config.changeLEDBrightness(value);
            }
        }
        if (((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).getPushVersion() == PushVersion.VERSION_2) {
            switch (index) {
                case 4: {
                    config.changePadSensitivity(value);
                    break;
                }
                case 5: {
                    config.changePadGain(value);
                    break;
                }
                case 6: {
                    config.changePadDynamics(value);
                    break;
                }
            }
        } else {
            switch (index) {
                case 4: {
                    config.changePadCurveThresholdPush3(value);
                    break;
                }
                case 5: {
                    config.changePadCurveDrivePush3(value);
                    break;
                }
                case 6: {
                    config.changePadCurveCompandPush3(value);
                    break;
                }
                case 7: {
                    config.changePadCurveRangePush3(value);
                    break;
                }
            }
        }
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        this.setTouchedKnob(index, isTouched);
        if (!isTouched || !((PushControlSurface)this.surface).isDeletePressed()) {
            return;
        }
        ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.DELETE);
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        switch (index) {
            case 1: {
                config.setDisplayBrightness(100);
                return;
            }
            case 2: {
                config.setLEDBrightness(100);
                return;
            }
        }
        if (((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).getPushVersion() == PushVersion.VERSION_2) {
            switch (index) {
                case 4: {
                    config.setPadSensitivityPush2(5);
                    break;
                }
                case 5: {
                    config.setPadGainPush2(5);
                    break;
                }
                case 6: {
                    config.setPadDynamicsPush2(5);
                    break;
                }
            }
        } else {
            switch (index) {
                case 4: {
                    config.setPadCurveThresholdPush3(7);
                    break;
                }
                case 5: {
                    config.setPadCurveDrivePush3(4);
                    break;
                }
                case 6: {
                    config.setPadCurveCompandPush3(-26);
                    break;
                }
                case 7: {
                    config.setPadCurveRangePush3(35);
                    break;
                }
            }
        }
    }

    @Override
    public void updateDisplay2(IGraphicDisplay display) {
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        int displayBrightness = config.getDisplayBrightness();
        int ledBrightness = config.getLedBrightness();
        display.addOptionElement("Brightness", this.menu[0], false, "", "", false, true);
        display.addParameterElement(this.menu[1], true, "", (ChannelType)null, null, false, "Display", displayBrightness * 1023 / 100, displayBrightness + "%", this.isKnobTouched(1), -1);
        display.addParameterElement(this.menu[2], false, "", (ChannelType)null, null, false, "LEDs", ledBrightness * 1023 / 100, ledBrightness + "%", this.isKnobTouched(2), -1);
        display.addOptionElement("        Pads", this.menu[3], false, "", "", false, true);
        if (((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).getPushVersion() == PushVersion.VERSION_2) {
            int padSensitivity = config.getPadSensitivityPush2();
            int padGain = config.getPadGainPush2();
            int padDynamics = config.getPadDynamicsPush2();
            display.addParameterElement(" ", false, "", (ChannelType)null, null, false, "Sensitivity", padSensitivity * 1023 / 10, Integer.toString(padSensitivity), this.isKnobTouched(4), -1);
            display.addParameterElement(" ", false, "", (ChannelType)null, null, false, "Gain", padGain * 1023 / 10, Integer.toString(padGain), this.isKnobTouched(5), -1);
            display.addParameterElement(" ", false, "", (ChannelType)null, null, false, "Dynamics", padDynamics * 1023 / 10, Integer.toString(padDynamics), this.isKnobTouched(6), -1);
            display.addOptionElement("", " ", false, "", "", false, true);
        } else {
            int padThreshold = config.getPadCurveThresholdPush3();
            int padDrive = config.getPadCurveDrivePush3();
            int padCompand = config.getPadCurveCompandPush3();
            int padRange = config.getPadCurveRangePush3();
            display.addParameterElement(" ", false, "", (ChannelType)null, null, false, "Threshold", padThreshold * 1023 / 100, Integer.toString(padThreshold), this.isKnobTouched(4), -1);
            display.addParameterElement(" ", false, "", (ChannelType)null, null, false, "Drive", (padDrive + 50) * 1023 / 100, Integer.toString(padDrive), this.isKnobTouched(5), -1);
            display.addParameterElement(" ", false, "", (ChannelType)null, null, false, "Compand", (padCompand + 50) * 1023 / 100, Integer.toString(padCompand), this.isKnobTouched(6), -1);
            display.addParameterElement(" ", false, "", (ChannelType)null, null, false, "Range", padRange * 1023 / 100, Integer.toString(padRange), this.isKnobTouched(7), -1);
        }
        if (config.getPushVersion() == PushVersion.VERSION_2) {
            display.addGraphOverlay(380, 84, 90, 34, ColorEx.WHITE, ((PushControlSurface)this.surface).createPadSensitivityCurvePush2(), 128);
        } else {
            display.addGraphOverlay(380, 84, 90, 34, ColorEx.WHITE, ((PushControlSurface)this.surface).createPadSensitivityCurvePush3(), 128);
        }
    }
}

