/*
 * Decompiled with CFR 0.152.
 */
package purejavahidapi.hidparser;

import purejavahidapi.hidparser.Collection;
import purejavahidapi.hidparser.HidParser;
import purejavahidapi.hidparser.Report;

public final class Field {
    Report m_Report;
    Collection m_Collection;
    int m_Physical;
    int m_Logical;
    int m_Application;
    int m_Usage;
    int m_Flags;
    int m_ReportOffset;
    int m_ReportSize;
    int m_ReportType;
    int m_LogicalMinimum;
    int m_LogicalMaximum;
    int m_PhysicalMinimum;
    int m_PhysicalMaximum;
    int m_UnitExponent;
    int m_Unit;

    Field(Collection collection) {
        this.m_Collection = collection;
        this.m_Collection.add(this);
    }

    public void dump(String tab) {
        HidParser.printf(String.valueOf(tab) + "-FIELD-------------------------\n", new Object[0]);
        HidParser.printf(String.valueOf(tab) + "        usage: 0x%04X:0x%04X\n", 0xFFFF & this.m_Usage >> 16 & 0xFFFF, this.m_Usage & 0xFFFF);
        HidParser.printf(String.valueOf(tab) + "        flags: 0x%08X\n", this.m_Flags);
        HidParser.printf(String.valueOf(tab) + "    report id: 0x%02X\n", this.m_Report.m_Id);
        HidParser.printf(String.valueOf(tab) + "         type: %s\n", (new String[]{"input", "output", "feature"})[this.m_Report.m_Type]);
        HidParser.printf(String.valueOf(tab) + "       offset: %d\n", this.m_ReportOffset);
        HidParser.printf(String.valueOf(tab) + "         size: %d\n", this.m_ReportSize);
        HidParser.printf(String.valueOf(tab) + "  logical min: %d\n", this.m_LogicalMinimum);
        HidParser.printf(String.valueOf(tab) + "  logical max: %d\n", this.m_LogicalMaximum);
        HidParser.printf(String.valueOf(tab) + " physical min: %d\n", this.m_PhysicalMinimum);
        HidParser.printf(String.valueOf(tab) + " physical max: %d\n", this.m_PhysicalMaximum);
        HidParser.printf(String.valueOf(tab) + "         unit: %d\n", this.m_Unit);
        HidParser.printf(String.valueOf(tab) + "     unit exp: %d\n", this.m_UnitExponent);
    }
}

