/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.parameterprovider.device;

import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.data.IChannel;
import de.mossgrabers.framework.daw.data.bank.IChannelBank;
import de.mossgrabers.framework.observer.IBankPageObserver;
import de.mossgrabers.framework.observer.IParametersAdjustObserver;
import de.mossgrabers.framework.parameterprovider.AbstractParameterProvider;
import java.util.Optional;

public abstract class AbstractChannelParameterProvider<B extends IChannelBank<C>, C extends IChannel>
extends AbstractParameterProvider
implements IBankPageObserver {
    protected IChannelBank<? extends IChannel> bank;

    protected AbstractChannelParameterProvider(B bank) {
        this.bank = bank;
    }

    @Override
    public int size() {
        return this.bank.getPageSize();
    }

    @Override
    public void addParametersObserver(IParametersAdjustObserver observer) {
        super.addParametersObserver(observer);
        this.bank.addPageObserver(this);
    }

    @Override
    public void removeParametersObserver(IParametersAdjustObserver observer) {
        super.removeParametersObserver(observer);
        if (!this.hasObservers()) {
            this.bank.removePageObserver(this);
        }
    }

    @Override
    public void pageAdjusted() {
        this.notifyParametersObservers();
    }

    @Override
    public Optional<ColorEx> getColor(int index) {
        return Optional.of(((IChannel)this.bank.getItem(index)).getColor());
    }
}

