/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.graphics;

import de.mossgrabers.framework.graphics.IGraphicsDimensions;

public class DefaultGraphicsDimensions
implements IGraphicsDimensions {
    private static final double SEPARATOR_SIZE = 2.0;
    private final int width;
    private final int height;
    private final double unit;
    private final double doubleUnit;
    private final double halfUnit;
    private final double menuHeight;
    private final double inset;
    private final double controlsTop;
    private final int maxParameterValue;

    public DefaultGraphicsDimensions(int width, int height, int maxParameterValue) {
        this.width = width;
        this.height = height;
        this.unit = (double)height / 12.0;
        this.doubleUnit = 2.0 * this.unit;
        this.halfUnit = this.unit / 2.0;
        this.menuHeight = this.unit + 4.0;
        this.inset = 1.0 + this.halfUnit;
        this.controlsTop = this.menuHeight + this.inset;
        this.maxParameterValue = maxParameterValue;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public double getSeparatorSize() {
        return 2.0;
    }

    @Override
    public double getMenuHeight() {
        return this.menuHeight;
    }

    @Override
    public double getUnit() {
        return this.unit;
    }

    @Override
    public double getHalfUnit() {
        return this.halfUnit;
    }

    @Override
    public double getDoubleUnit() {
        return this.doubleUnit;
    }

    @Override
    public double getControlsTop() {
        return this.controlsTop;
    }

    @Override
    public double getInset() {
        return this.inset;
    }

    @Override
    public int getParameterUpperBound() {
        return this.maxParameterValue;
    }
}

