/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.trigger.transport;

import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.command.trigger.clip.NewCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.FrameworkException;
import java.util.Optional;

public class RecordCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractTriggerCommand<S, C> {
    protected final ITransport transport;
    private final NewCommand<S, C> newCmd;
    private ButtonID recordTrigger;
    private ButtonID launcherOverdubTrigger;
    private ButtonID newTrigger;

    public RecordCommand(IModel model, S surface) {
        this(model, surface, null, ButtonID.SHIFT, ButtonID.SELECT);
    }

    public RecordCommand(IModel model, S surface, ButtonID recordTrigger, ButtonID launcherOverdubTrigger, ButtonID newTrigger) {
        super(model, surface);
        this.recordTrigger = recordTrigger;
        this.launcherOverdubTrigger = launcherOverdubTrigger;
        this.newTrigger = newTrigger;
        if (this.recordTrigger == this.launcherOverdubTrigger || this.recordTrigger == this.newTrigger || this.launcherOverdubTrigger == this.newTrigger) {
            throw new FrameworkException("Duplicated record modifier!");
        }
        this.newCmd = new NewCommand(model, surface);
        this.transport = this.model.getTransport();
    }

    @Override
    public void execute(ButtonEvent event, int velocity) {
        switch (this.getActiveAction().ordinal()) {
            case 0: {
                this.executeRecord(event);
                break;
            }
            case 1: {
                this.executeLauncherOverdub(event);
                break;
            }
            case 2: {
                this.executeNew(event);
            }
        }
    }

    protected void executeRecord(ButtonEvent event) {
        if (event == ButtonEvent.UP) {
            this.handleExecute(false);
        }
    }

    protected void executeLauncherOverdub(ButtonEvent event) {
        if (event == ButtonEvent.UP) {
            this.handleExecute(true);
        }
    }

    protected void executeNew(ButtonEvent event) {
        if (event == ButtonEvent.UP) {
            this.newCmd.executeNormal(event);
        }
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (event == ButtonEvent.DOWN) {
            this.handleExecute(false);
        }
    }

    @Override
    public void executeShifted(ButtonEvent event) {
        if (event == ButtonEvent.DOWN) {
            this.handleExecute(true);
        }
    }

    protected void handleExecute(boolean isShiftPressed) {
        boolean flipRecord = this.surface.getConfiguration().isFlipRecord();
        if (isShiftPressed && !flipRecord || !isShiftPressed && flipRecord) {
            ISlot slot;
            Optional selectedSlot;
            Optional selectedTrack = this.model.getCurrentTrackBank().getSelectedItem();
            if (selectedTrack.isPresent() && (selectedSlot = ((ITrack)selectedTrack.get()).getSlotBank().getSelectedItem()).isPresent() && (slot = (ISlot)selectedSlot.get()).isRecording()) {
                slot.launch(true, false);
                return;
            }
            this.transport.toggleLauncherOverdub();
        } else {
            this.transport.startRecording();
        }
    }

    public boolean isActive() {
        switch (this.getActiveAction().ordinal()) {
            case 0: {
                return this.transport.isRecording();
            }
            case 1: {
                return this.getLauncherOverdubState();
            }
        }
        return false;
    }

    protected boolean getLauncherOverdubState() {
        return this.transport.isLauncherOverdub();
    }

    private ActiveAction getActiveAction() {
        if (this.recordTrigger != null && this.surface.isPressed(this.recordTrigger)) {
            return ActiveAction.RECORD;
        }
        if (this.launcherOverdubTrigger != null && this.surface.isPressed(this.launcherOverdubTrigger)) {
            return ActiveAction.LAUNCHER_OVERDUB;
        }
        if (this.newTrigger != null && this.surface.isPressed(this.newTrigger)) {
            return ActiveAction.NEW_CLIP;
        }
        if (this.recordTrigger == null) {
            return ActiveAction.RECORD;
        }
        if (this.launcherOverdubTrigger == null) {
            return ActiveAction.LAUNCHER_OVERDUB;
        }
        return ActiveAction.NEW_CLIP;
    }

    private static enum ActiveAction {
        RECORD,
        LAUNCHER_OVERDUB,
        NEW_CLIP;

    }
}

