/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.mk3.view;

import de.mossgrabers.controller.ni.maschine.mk3.MaschineConfiguration;
import de.mossgrabers.controller.ni.maschine.mk3.controller.MaschineControlSurface;
import de.mossgrabers.controller.ni.maschine.mk3.view.BaseView;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.daw.DAWColor;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.ISessionAlternative;
import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ISlotBank;
import de.mossgrabers.framework.utils.ButtonEvent;
import java.util.Optional;

public class ClipView
extends BaseView
implements ISessionAlternative {
    private boolean wasAlternateInteractionUsed = false;

    public ClipView(MaschineControlSurface surface, IModel model) {
        super("Clip", surface, model);
    }

    @Override
    public void onGridNote(int note, int velocity) {
        super.onGridNote(note, velocity);
        if (((MaschineControlSurface)this.surface).isShiftPressed()) {
            this.wasAlternateInteractionUsed = true;
        }
    }

    @Override
    public void executeFunction(int padIndex, ButtonEvent buttonEvent) {
        boolean isDown = buttonEvent == ButtonEvent.DOWN;
        Optional track = this.model.getCurrentTrackBank().getSelectedItem();
        if (track.isEmpty()) {
            return;
        }
        ISlot slot = (ISlot)((ITrack)track.get()).getSlotBank().getItem(padIndex);
        MaschineConfiguration configuration = (MaschineConfiguration)((MaschineControlSurface)this.surface).getConfiguration();
        if (isDown) {
            if (this.isButtonCombination(ButtonID.DUPLICATE)) {
                if (((ITrack)track.get()).doesExist()) {
                    slot.duplicate();
                }
                return;
            }
            if (this.isButtonCombination(ButtonID.CLIP)) {
                ((ITrack)track.get()).stop(((MaschineControlSurface)this.surface).isShiftPressed());
                return;
            }
            if (this.isButtonCombination(ButtonID.BROWSE)) {
                if (((ITrack)track.get()).doesExist()) {
                    this.model.getBrowser().replace(slot);
                }
                return;
            }
            if (this.isButtonCombination(ButtonID.DELETE)) {
                slot.remove();
                return;
            }
            if (this.isButtonCombination(ButtonID.SELECT)) {
                slot.select();
                return;
            }
            if (configuration.isSelectClipOnLaunch()) {
                slot.select();
            }
        }
        if (!((ITrack)track.get()).isRecArm() || slot.hasContent()) {
            slot.launch(isDown, ((MaschineControlSurface)this.surface).isShiftPressed());
            return;
        }
        if (isDown) {
            switch (configuration.getActionForRecArmedPad()) {
                case 0: {
                    this.model.recordNoteClip((ITrack)track.get(), slot);
                    break;
                }
                case 1: {
                    int lengthInBeats = configuration.getNewClipLenghthInBeats(this.model.getTransport().getQuartersPerMeasure());
                    this.model.createNoteClip((ITrack)track.get(), slot, lengthInBeats, true);
                    break;
                }
            }
        }
    }

    @Override
    public void drawGrid() {
        IPadGrid padGrid = ((MaschineControlSurface)this.surface).getPadGrid();
        Optional selectedTrack = this.model.getCurrentTrackBank().getSelectedItem();
        if (selectedTrack.isEmpty()) {
            return;
        }
        ISlotBank slotBank = ((ITrack)selectedTrack.get()).getSlotBank();
        for (int i = 0; i < 16; ++i) {
            ISlot item = (ISlot)slotBank.getItem(i);
            int x = i % 4;
            int y = 3 - i / 4;
            if (item.doesExist()) {
                if (item.isRecordingQueued()) {
                    padGrid.lightEx(x, y, 5);
                    continue;
                }
                if (item.isRecording()) {
                    padGrid.lightEx(x, y, 6);
                    continue;
                }
                if (item.isPlayingQueued()) {
                    padGrid.lightEx(x, y, 29);
                    continue;
                }
                if (item.isPlaying()) {
                    padGrid.lightEx(x, y, 30);
                    continue;
                }
                if (item.isStopQueued()) {
                    padGrid.lightEx(x, y, 29);
                    continue;
                }
                padGrid.lightEx(x, y, DAWColor.getColorID(item.getColor()));
                continue;
            }
            padGrid.lightEx(x, y, "BUTTON_COLOR_OFF");
        }
    }

    @Override
    public boolean wasAlternateInteractionUsed() {
        return this.wasAlternateInteractionUsed;
    }

    @Override
    public void setAlternateInteractionUsed(boolean wasUsed) {
        this.wasAlternateInteractionUsed = wasUsed;
    }
}

