/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.core;

import de.mossgrabers.controller.ni.maschine.Maschine;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.AbstractControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.utils.ButtonEvent;

public abstract class AbstractMaschineControlSurface<C extends Configuration>
extends AbstractControlSurface<C> {
    protected final Maschine maschine;
    protected boolean isSysexShift = false;

    protected AbstractMaschineControlSurface(IHost host, C configuration, ColorManager colorManager, Maschine maschine, IMidiOutput output, IMidiInput input, IPadGrid padGrid, double width, double height) {
        super(host, configuration, colorManager, output, input, padGrid, width, height);
        this.maschine = maschine;
        this.input.setSysexCallback(this::handleSysEx);
    }

    public Maschine getMaschine() {
        return this.maschine;
    }

    @Override
    public boolean isShiftPressed() {
        if (this.maschine.hasShift()) {
            return this.isSysexShift;
        }
        return this.isPressed(this.maschine == Maschine.STUDIO ? ButtonID.SHIFT : ButtonID.STOP);
    }

    protected void handleSysEx(String data) {
        if (this.maschine.getMessageShiftDown().equalsIgnoreCase(data)) {
            this.isSysexShift = true;
            this.getButton(ButtonID.SHIFT).trigger(ButtonEvent.DOWN);
            return;
        }
        if (this.maschine.getMessageShiftUp().equalsIgnoreCase(data)) {
            this.isSysexShift = false;
            this.getButton(ButtonID.SHIFT).trigger(ButtonEvent.UP);
            return;
        }
        if (this.maschine.getMessageReturnFromHost().equalsIgnoreCase(data)) {
            this.forceFlush();
            return;
        }
        this.host.error("Unhandled Sysex message: " + data);
    }
}

