/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.kontrol.mkii;

import de.mossgrabers.framework.daw.resource.ChannelType;

public class TrackType {
    public static final int EMPTY = 0;
    public static final int GENERIC = 1;
    public static final int MIDI = 2;
    public static final int AUDIO = 3;
    public static final int GROUP = 4;
    public static final int RETURN_BUS = 5;
    public static final int MASTER = 6;

    private TrackType() {
    }

    public static ChannelType toChannelType(int trackType) {
        switch (trackType) {
            case 1: {
                return ChannelType.HYBRID;
            }
            case 3: {
                return ChannelType.AUDIO;
            }
            case 2: {
                return ChannelType.INSTRUMENT;
            }
            case 4: {
                return ChannelType.GROUP;
            }
            case 5: {
                return ChannelType.EFFECT;
            }
            case 6: {
                return ChannelType.MASTER;
            }
        }
        return ChannelType.UNKNOWN;
    }

    public static int toTrackType(ChannelType channelType) {
        switch (channelType) {
            case HYBRID: {
                return 3;
            }
            case AUDIO: {
                return 3;
            }
            case INSTRUMENT: {
                return 2;
            }
            case GROUP: 
            case GROUP_OPEN: {
                return 4;
            }
            case EFFECT: {
                return 5;
            }
            case MASTER: {
                return 6;
            }
            case LAYER: {
                return 3;
            }
        }
        return 0;
    }
}

