/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.intuitiveinstruments.exquis.view;

import de.mossgrabers.controller.intuitiveinstruments.exquis.ExquisConfiguration;
import de.mossgrabers.controller.intuitiveinstruments.exquis.controller.ExquisControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.AbstractView;
import de.mossgrabers.framework.scale.Scales;

public class ExquisNoteView
extends AbstractView<ExquisControlSurface, ExquisConfiguration> {
    private int cachedTempo = -1;

    public ExquisNoteView(ExquisControlSurface surface, IModel model) {
        super("Note", surface, model);
    }

    @Override
    public void onActivate() {
        ((ExquisControlSurface)this.surface).configureDeveloperMode(34);
        super.onActivate();
        ((ExquisControlSurface)this.surface).forceFlush();
    }

    @Override
    public void drawGrid() {
        double tempo = this.model.getTransport().getTempo();
        int intTempo = Math.clamp(Math.round(tempo), 20, 240);
        if (this.cachedTempo != intTempo) {
            this.cachedTempo = intTempo;
            ((ExquisControlSurface)this.surface).updateTempo(intTempo);
        }
    }

    @Override
    public void onGridNote(int note, int velocity) {
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        return this.colorManager.getColorIndex("GRID_COLOR_OFF");
    }

    @Override
    public void updateNoteMapping() {
        ((ExquisControlSurface)this.surface).scheduleTask(() -> this.delayedUpdateNoteMapping(Scales.getIdentityMatrix()), 100L);
    }
}

