/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.intuitiveinstruments.exquis.controller;

import de.mossgrabers.controller.intuitiveinstruments.exquis.controller.ExquisControlSurface;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.grid.PadGridImpl;
import de.mossgrabers.framework.daw.midi.IMidiOutput;

public class ExquisPadGrid
extends PadGridImpl {
    private ExquisControlSurface surface;

    public ExquisPadGrid(ColorManager colorManager, IMidiOutput output) {
        super(colorManager, output, 1, 61, 36);
    }

    public void setSurface(ExquisControlSurface surface) {
        this.surface = surface;
    }

    @Override
    public int translateToGrid(int note) {
        return note + 36;
    }

    @Override
    public int[] translateToController(int note) {
        return new int[]{15, note - 36};
    }

    @Override
    protected void sendNoteState(int channel, int note, int color) {
        if (this.surface != null) {
            this.surface.setLED(note, this.colorManager.getColor(color, null));
        }
    }

    @Override
    protected void sendBlinkState(int channel, int note, int blinkColor, boolean fast) {
        if (this.surface != null) {
            this.surface.setLED(note, this.colorManager.getColor(blinkColor, null), 127);
        }
    }
}

