/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.intuitiveinstruments.exquis;

import de.mossgrabers.controller.intuitiveinstruments.exquis.ExquisConfiguration;
import de.mossgrabers.controller.intuitiveinstruments.exquis.command.trigger.ExquisDeviceParameterModeSelectCommand;
import de.mossgrabers.controller.intuitiveinstruments.exquis.command.trigger.ExquisProjectParameterModeSelectCommand;
import de.mossgrabers.controller.intuitiveinstruments.exquis.command.trigger.ExquisRepeatCommand;
import de.mossgrabers.controller.intuitiveinstruments.exquis.command.trigger.ExquisSessionCommand;
import de.mossgrabers.controller.intuitiveinstruments.exquis.command.trigger.ExquisTrackModeSelectionCommand;
import de.mossgrabers.controller.intuitiveinstruments.exquis.command.trigger.ExquisTrackParameterModeSelectCommand;
import de.mossgrabers.controller.intuitiveinstruments.exquis.controller.ExquisColorManager;
import de.mossgrabers.controller.intuitiveinstruments.exquis.controller.ExquisControlSurface;
import de.mossgrabers.controller.intuitiveinstruments.exquis.controller.ExquisPadGrid;
import de.mossgrabers.controller.intuitiveinstruments.exquis.controller.ISysexCallback;
import de.mossgrabers.controller.intuitiveinstruments.exquis.mode.ExquisArpeggiatorMode;
import de.mossgrabers.controller.intuitiveinstruments.exquis.mode.ExquisParameterMode;
import de.mossgrabers.controller.intuitiveinstruments.exquis.mode.ExquisProjectTrackParameterMode;
import de.mossgrabers.controller.intuitiveinstruments.exquis.mode.ExquisTrackMode;
import de.mossgrabers.controller.intuitiveinstruments.exquis.mode.ExquisVolumeMode;
import de.mossgrabers.controller.intuitiveinstruments.exquis.view.ExquisNoteView;
import de.mossgrabers.controller.intuitiveinstruments.exquis.view.ExquisSelectionView;
import de.mossgrabers.controller.intuitiveinstruments.exquis.view.ExquisSessionView;
import de.mossgrabers.framework.command.continuous.KnobRowModeCommand;
import de.mossgrabers.framework.command.core.TriggerCommand;
import de.mossgrabers.framework.command.trigger.application.RedoCommand;
import de.mossgrabers.framework.command.trigger.application.UndoCommand;
import de.mossgrabers.framework.command.trigger.transport.PlayCommand;
import de.mossgrabers.framework.command.trigger.transport.RecordCommand;
import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.AbstractControllerSetup;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.ISetupFactory;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.hardware.BindType;
import de.mossgrabers.framework.controller.hardware.IHwAbsoluteKnob;
import de.mossgrabers.framework.controller.hardware.IHwRelativeKnob;
import de.mossgrabers.framework.controller.valuechanger.OffsetBinaryRelativeValueChanger;
import de.mossgrabers.framework.controller.valuechanger.RelativeEncoding;
import de.mossgrabers.framework.daw.IApplication;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.ModelSetup;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.daw.midi.IMidiAccess;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.daw.midi.INoteInput;
import de.mossgrabers.framework.featuregroup.IMode;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.Views;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class ExquisControllerSetup
extends AbstractControllerSetup<ExquisControlSurface, ExquisConfiguration>
implements ISysexCallback {
    private static final int MIDI_CHANNEL = 15;
    protected boolean isMoveTracks;
    private IHwAbsoluteKnob touchstrip;
    private final Map<Integer, byte[]> trackSettings = new HashMap<Integer, byte[]>();
    private int previousTrackPosition = -1;

    public ExquisControllerSetup(IHost host, ISetupFactory factory, ISettingsUI globalSettings, ISettingsUI documentSettings) {
        super(factory, host, globalSettings, documentSettings);
        this.colorManager = new ExquisColorManager();
        this.valueChanger = new OffsetBinaryRelativeValueChanger(128, 1);
        this.configuration = new ExquisConfiguration(host, this.valueChanger, factory.getArpeggiatorModes());
    }

    @Override
    protected void createModel() {
        ModelSetup ms = new ModelSetup();
        ms.enableMainDrumDevice(false);
        ms.setNumTracks(4);
        ms.setHasFlatTrackList(true);
        ms.setHasFullFlatTrackList(true);
        ms.setNumSends(2);
        ms.setNumScenes(7);
        ms.setNumDevicesInBank(22);
        ms.setNumParamPages(22);
        ms.setNumFilterColumnEntries(0);
        ms.setNumResults(0);
        ms.setNumDeviceLayers(0);
        ms.setNumDrumPadLayers(0);
        this.model = this.factory.createModel(this.configuration, this.colorManager, this.valueChanger, this.scales, ms);
        ITrackBank trackBank = this.model.getTrackBank();
        trackBank.setIndication(true);
        trackBank.addSelectionObserver((index, isSelected) -> this.handleTrackChange(index, isSelected));
        trackBank.addPageObserver(() -> this.handleTrackChange(-1, true));
    }

    @Override
    protected void createSurface() {
        IMidiAccess midiAccess = this.factory.createMidiAccess();
        ArrayList filters = new ArrayList();
        for (int i = 0; i < 15; ++i) {
            String midiChannel = Integer.toHexString(i).toUpperCase(Locale.US);
            Collections.addAll(filters, "8" + midiChannel + "????", "9" + midiChannel + "????", "B" + midiChannel + "40??", "B" + midiChannel + "4A??", "A" + midiChannel + "????", "D" + midiChannel + "????", "E" + midiChannel + "????");
        }
        IMidiInput input = midiAccess.createInput("Exquis", filters.toArray(new String[filters.size()]));
        INoteInput noteInput = input.getDefaultNoteInput();
        noteInput.enableMPE(true);
        IMidiOutput output = midiAccess.createOutput();
        ExquisPadGrid padGrid = new ExquisPadGrid(this.colorManager, output);
        ExquisControlSurface surface = new ExquisControlSurface(this.host, this.colorManager, (ExquisConfiguration)this.configuration, output, input, padGrid, this);
        this.surfaces.add(surface);
        surface.getModeManager().setDefaultID(Modes.TRACK);
    }

    @Override
    protected void createModes() {
        ExquisControlSurface surface = (ExquisControlSurface)this.getSurface();
        ModeManager modeManager = surface.getModeManager();
        modeManager.register(Modes.TRACK, new ExquisTrackMode(surface, this.model));
        modeManager.register(Modes.VOLUME, new ExquisVolumeMode(surface, this.model));
        modeManager.register(Modes.PROJECT_PARAMETERS, new ExquisProjectTrackParameterMode(surface, this.model, true));
        modeManager.register(Modes.TRACK_PARAMETERS, new ExquisProjectTrackParameterMode(surface, this.model, false));
        modeManager.register(Modes.DEVICE_PARAMS, new ExquisParameterMode(surface, this.model));
        modeManager.register(Modes.REPEAT_NOTE, new ExquisArpeggiatorMode(surface, this.model));
    }

    @Override
    protected void createViews() {
        ExquisControlSurface surface = (ExquisControlSurface)this.getSurface();
        ViewManager viewManager = surface.getViewManager();
        viewManager.register(Views.PLAY, new ExquisNoteView(surface, this.model));
        viewManager.register(Views.TRACK_SELECT, new ExquisSelectionView(surface, this.model));
        viewManager.register(Views.SESSION, new ExquisSessionView(surface, this.model));
    }

    @Override
    protected void createObservers() {
        super.createObservers();
        ExquisControlSurface surface = (ExquisControlSurface)this.getSurface();
        ((ExquisConfiguration)this.configuration).registerDeactivatedItemsHandler(this.model);
        ((ExquisConfiguration)this.configuration).addSettingObserver(AbstractConfiguration.MPE_PITCHBEND_RANGE, () -> surface.scheduleTask(() -> {
            INoteInput input = surface.getMidiInput().getDefaultNoteInput();
            IMidiOutput output = surface.getMidiOutput();
            if (input == null || output == null) {
                return;
            }
            int mpePitchBendRange = ((ExquisConfiguration)this.configuration).getMPEPitchBendRange();
            input.setMPEPitchBendSensitivity(mpePitchBendRange);
        }, 2000L));
        ((ExquisConfiguration)this.configuration).addSettingObserver(AbstractConfiguration.SCALES_SCALE, () -> {
            String scaleName = ((ExquisConfiguration)this.configuration).getScale();
            surface.updateScale(AbstractConfiguration.lookupIndex(ExquisConfiguration.EXQUISE_SCALES, scaleName));
        });
        ((ExquisConfiguration)this.configuration).addSettingObserver(AbstractConfiguration.SCALES_BASE, () -> {
            this.scales.setScaleOffsetByName(((ExquisConfiguration)this.configuration).getScaleBase());
            surface.updateRootNote(this.scales.getScaleOffset());
        });
        this.createNoteRepeatObservers((ExquisConfiguration)this.configuration, surface);
    }

    @Override
    protected void registerTriggerCommands() {
        ExquisControlSurface surface = (ExquisControlSurface)this.getSurface();
        ITransport t = this.model.getTransport();
        IApplication application = this.model.getApplication();
        ViewManager viewManager = surface.getViewManager();
        this.addButton(ButtonID.PLAY, "Play", new PlayCommand(this.model, surface), 15, 105, () -> t.isPlaying() ? 1 : 0, "PLAY_OFF", "PLAY_ON");
        this.addButton(ButtonID.RECORD, "Record", new RecordCommand(this.model, surface), 15, 102, () -> t.isRecording() ? 1 : 0, "RECORD_OFF", "RECORD_ON");
        this.addButton(ButtonID.LOOP, "Loop", (TriggerCommand)new ExquisRepeatCommand(this.model, surface), 15, 103, () -> t.isLoop() ? 1 : 0, "LOOP_OFF", "LOOP_ON");
        this.addButton(ButtonID.SESSION, "Session", (TriggerCommand)new ExquisSessionCommand(this.model, surface), 15, 104, () -> viewManager.isActive(new Views[]{Views.SESSION}) ? 1 : 0, "SESSION_OFF", "SESSION_ON");
        this.addButton(ButtonID.UNDO, "Undo", new UndoCommand(this.model, surface), 15, 108, () -> application.canUndo() ? 1 : 0, "DO_OFF", "DO_ON");
        this.addButton(ButtonID.REDO, "Redo", new RedoCommand(this.model, surface), 15, 109, () -> application.canRedo() ? 1 : 0, "DO_OFF", "DO_ON");
        this.addButton(ButtonID.KNOB1_TOUCH, "Knob 1 Press", (TriggerCommand)new ExquisProjectParameterModeSelectCommand(this.model, surface), 15, 114);
        this.addButton(ButtonID.KNOB2_TOUCH, "Knob 2 Press", (TriggerCommand)new ExquisTrackParameterModeSelectCommand(this.model, surface), 15, 115);
        this.addButton(ButtonID.KNOB3_TOUCH, "Knob 3 Press", (TriggerCommand)new ExquisDeviceParameterModeSelectCommand(this.model, surface), 15, 116);
        this.addButton(ButtonID.KNOB4_TOUCH, "Knob 4 Press", (TriggerCommand)new ExquisTrackModeSelectionCommand(this.model, surface), 15, 117);
        this.addButton(ButtonID.DOWN, "Down", (ButtonEvent event, int velocity) -> this.setScrollMode(event, false), 15, 106, () -> 0, "COLOR_SCENE");
        this.addButton(ButtonID.UP, "Up", (ButtonEvent event, int velocity) -> this.setScrollMode(event, true), 15, 107, () -> 0, "TRACKS_COLOR");
    }

    @Override
    protected void registerContinuousCommands() {
        ExquisControlSurface surface = (ExquisControlSurface)this.getSurface();
        ModeManager modeManager = surface.getModeManager();
        int knobIndex = 0;
        while (knobIndex < 4) {
            ContinuousID knobID = ContinuousID.get(ContinuousID.KNOB1, knobIndex);
            int cc = 110 + knobIndex;
            IHwRelativeKnob relativeKnob = this.addRelativeKnob(knobID, "Knob " + (knobIndex + 1), new KnobRowModeCommand(knobIndex, this.model, surface), BindType.CC, 15, cc, RelativeEncoding.OFFSET_BINARY);
            relativeKnob.setIndexInGroup(knobIndex);
            int ki = knobIndex++;
            relativeKnob.addOutput(() -> {
                IMode mode = (IMode)modeManager.getActive();
                return mode == null ? 0 : Math.max(0, mode.getKnobValue(ki));
            }, value -> {
                IMode mode = (IMode)modeManager.getActive();
                if (mode == null) {
                    return;
                }
                ColorEx color = this.colorManager.getColor(mode.getKnobColor(ki), null);
                double factor = this.valueChanger.toNormalizedValue(value);
                surface.setLED(cc, color.dim(factor));
            });
        }
        this.touchstrip = this.addAbsoluteKnob(ContinuousID.TOUCHSTRIP, "Touchstrip", this::selectBankPage, BindType.CC, 15, 90);
        this.touchstrip.addOutput(() -> this.isMoveTracks ? this.model.getTrackBank().getScrollPosition() / 4 : this.model.getSceneBank().getScrollPosition() / 7, value -> {
            ColorEx hiColor = this.isMoveTracks ? ColorEx.BLUE : ColorEx.GREEN;
            for (int i = 0; i < 6; ++i) {
                surface.setLED(80 + i, i == value ? hiColor : ColorEx.BLACK);
            }
        });
    }

    @Override
    public void startup() {
        ExquisControlSurface surface = (ExquisControlSurface)this.getSurface();
        surface.getViewManager().setActive(Views.PLAY);
        surface.getModeManager().setActive(Modes.TRACK);
        this.host.scheduleTask(surface::forceFlush, 1000L);
    }

    @Override
    public void updateTempo(int tempo) {
        ITransport transport = this.model.getTransport();
        transport.setTempo(tempo);
        this.host.showNotification("Tempo: " + transport.formatTempo(tempo));
    }

    @Override
    public void storeTrackSettings(int trackPosition, byte[] settings) {
        int position;
        int cursorTrackPosition = this.model.getCursorTrack().getPosition();
        boolean doesntNeedUpdate = trackPosition < 0;
        int n = position = doesntNeedUpdate ? cursorTrackPosition : trackPosition;
        if (position >= 0) {
            this.trackSettings.put(position, settings);
        }
        if (doesntNeedUpdate) {
            return;
        }
        byte[] trackSettings = this.trackSettings.get(cursorTrackPosition);
        if (trackSettings != null) {
            ((ExquisControlSurface)this.getSurface()).sendTrackSettings(trackSettings);
        }
    }

    protected void handleTrackChange(int index, boolean isSelected) {
        ITrackBank trackBank = this.model.getTrackBank();
        if (isSelected) {
            if (this.previousTrackPosition >= 0) {
                ((ExquisControlSurface)this.getSurface()).requestTrackSettings(this.previousTrackPosition);
            }
            ITrack item = index >= 0 ? (ITrack)trackBank.getItem(index) : this.model.getCursorTrack();
            this.previousTrackPosition = item.doesExist() ? item.getPosition() : -1;
        }
        this.handleTrackChange(isSelected);
    }

    @Override
    protected void recallLastView() {
        ExquisControlSurface surface = (ExquisControlSurface)this.getSurface();
        if (!surface.getViewManager().isActive(new Views[]{Views.SESSION, Views.TRACK_SELECT})) {
            surface.recallPreferredView(this.model.getCursorTrack());
        }
    }

    private void selectBankPage(int value) {
        if (value < 0 || value > 5) {
            return;
        }
        if (this.isMoveTracks) {
            this.model.getTrackBank().scrollTo(4 * value);
        } else {
            this.model.getSceneBank().scrollTo(7 * value);
        }
    }

    private void setScrollMode(ButtonEvent event, boolean isMoveTracks) {
        if (event == ButtonEvent.DOWN) {
            return;
        }
        this.isMoveTracks = isMoveTracks;
        this.host.showNotification(this.isMoveTracks ? "Scroll: Tracks" : "Scroll: Scenes");
        this.touchstrip.forceFlush();
    }
}

