/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.electra.one.mode;

import de.mossgrabers.controller.electra.one.controller.ElectraOneColorManager;
import de.mossgrabers.controller.electra.one.controller.ElectraOneControlSurface;
import de.mossgrabers.controller.electra.one.mode.AbstractElectraOneMode;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.daw.data.IDevice;
import de.mossgrabers.framework.daw.data.IMasterTrack;
import de.mossgrabers.framework.daw.data.bank.IDeviceBank;
import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.daw.data.bank.IParameterPageBank;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameter.PlayPositionParameter;
import de.mossgrabers.framework.parameterprovider.device.BankParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.CombinedParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.EmptyParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.FixedParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.RangeFilterParameterProvider;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.StringUtils;

public class DeviceMode
extends AbstractElectraOneMode {
    private final ITransport transport;
    private final IMasterTrack masterTrack;

    public DeviceMode(ElectraOneControlSurface surface, IModel model) {
        super(2, "Parameters", surface, model);
        this.transport = this.model.getTransport();
        this.masterTrack = this.model.getMasterTrack();
        BankParameterProvider bankParameterProvider = new BankParameterProvider(this.model.getCursorDevice().getParameterBank());
        EmptyParameterProvider emptyParameterProvider = new EmptyParameterProvider(1);
        this.setParameterProvider(new CombinedParameterProvider(emptyParameterProvider, new RangeFilterParameterProvider(bankParameterProvider, 0, 4), new FixedParameterProvider(this.masterTrack.getVolumeParameter()), emptyParameterProvider, new RangeFilterParameterProvider(bankParameterProvider, 4, 4), new FixedParameterProvider(new PlayPositionParameter(model.getValueChanger(), this.transport, surface)), new EmptyParameterProvider(24)));
    }

    @Override
    public void onButton(int row, int column, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        block0 : switch (column) {
            case 0: {
                switch (row) {
                    case 0: {
                        cursorDevice.toggleEnabledState();
                        break block0;
                    }
                    case 1: {
                        cursorDevice.toggleWindowOpen();
                        break block0;
                    }
                    case 2: {
                        cursorDevice.getParameterBank().getPageBank().selectNextPage();
                        break block0;
                    }
                    case 3: {
                        cursorDevice.getParameterBank().getPageBank().selectPreviousPage();
                        break block0;
                    }
                    case 4: {
                        cursorDevice.getDeviceBank().selectNextPage();
                        break block0;
                    }
                    case 5: {
                        cursorDevice.getDeviceBank().selectPreviousPage();
                        break block0;
                    }
                }
                break;
            }
            case 5: {
                switch (row) {
                    case 2: {
                        ICursorTrack cursorTrack = this.model.getCursorTrack();
                        boolean pinned = cursorDevice.isPinned();
                        cursorDevice.togglePinned();
                        boolean cursorTrackPinned = cursorTrack.isPinned();
                        if (pinned != cursorTrackPinned) break block0;
                        cursorTrack.togglePinned();
                        break;
                    }
                    case 3: {
                        cursorDevice.toggleExpanded();
                        break;
                    }
                    case 4: {
                        this.model.getTransport().startRecording();
                        break;
                    }
                    case 5: {
                        this.playCommand.execute(ButtonEvent.UP, 127);
                        break;
                    }
                }
                break;
            }
            default: {
                if (row < 2) {
                    return;
                }
                if (row == 2 || row == 3) {
                    cursorDevice.getParameterBank().getPageBank().selectPage((row - 2) * 4 + column - 1);
                    break;
                }
                ((IDevice)cursorDevice.getDeviceBank().getItem((row - 4) * 4 + column - 1)).select();
            }
        }
    }

    @Override
    public void updateDisplay() {
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        IParameterBank parameterBank = cursorDevice.getParameterBank();
        IParameterPageBank parameterPageBank = parameterBank.getPageBank();
        IDeviceBank siblingBank = cursorDevice.getDeviceBank();
        for (int i = 0; i < 8; ++i) {
            IParameter param = (IParameter)parameterBank.getItem(i);
            boolean exists = param.doesExist();
            int row = i / 4;
            int column = 1 + i % 4;
            this.pageCache.updateElement(row, column, exists ? StringUtils.fixASCII(param.getName()) : "", exists ? ColorEx.ORANGE : ColorEx.BLACK, exists);
            this.pageCache.updateValue(row, column, param.getValue(), exists ? StringUtils.optimizeName(StringUtils.fixASCII(param.getDisplayedValue()), 15) : " ");
            String paramPage = (String)parameterPageBank.getItem(i);
            boolean isSelected = parameterPageBank.getSelectedItemIndex() == i;
            boolean pageExists = !paramPage.isBlank();
            ColorEx color = isSelected ? ElectraOneColorManager.PARAM_PAGE_SELECTED : ElectraOneColorManager.PARAM_PAGE;
            this.pageCache.updateElement(row += 2, column, pageExists ? StringUtils.fixASCII(paramPage) : " ", pageExists ? color : ColorEx.BLACK, pageExists);
            IDevice device = (IDevice)siblingBank.getItem(i);
            boolean deviceExists = device.doesExist();
            ColorEx deviceColor = cursorDevice.getIndex() == i ? ElectraOneColorManager.DEVICE_SELECTED : ElectraOneColorManager.DEVICE;
            this.pageCache.updateElement(row += 2, column, deviceExists ? StringUtils.fixASCII(device.getName()) : " ", deviceExists ? deviceColor : ColorEx.BLACK, deviceExists);
        }
        this.pageCache.updateColor(0, 0, cursorDevice.isEnabled() ? ElectraOneColorManager.DEVICE_ON : ElectraOneColorManager.DEVICE_OFF);
        this.pageCache.updateColor(1, 0, cursorDevice.isWindowOpen() ? ElectraOneColorManager.WINDOW_OPEN : ElectraOneColorManager.WINDOW);
        this.pageCache.updateColor(2, 5, cursorDevice.isPinned() ? ElectraOneColorManager.PINNED_ON : ElectraOneColorManager.PINNED_OFF);
        this.pageCache.updateColor(3, 5, cursorDevice.isExpanded() ? ElectraOneColorManager.EXPANDED_ON : ElectraOneColorManager.EXPANDED_OFF);
        this.pageCache.updateColor(0, 5, this.masterTrack.getColor());
        this.pageCache.updateValue(0, 5, this.masterTrack.getVolume(), StringUtils.optimizeName(StringUtils.fixASCII(this.masterTrack.getVolumeStr()), 15));
        this.pageCache.updateValue(1, 5, 0, StringUtils.optimizeName(StringUtils.fixASCII(this.transport.getBeatText()), 15));
        this.pageCache.updateElement(1, 5, StringUtils.optimizeName(StringUtils.fixASCII(this.transport.getPositionText()), 15), null, null);
        this.pageCache.updateColor(4, 5, this.transport.isRecording() ? ElectraOneColorManager.RECORD_ON : ElectraOneColorManager.RECORD_OFF);
        this.pageCache.updateColor(5, 5, this.transport.isPlaying() ? ElectraOneColorManager.PLAY_ON : ElectraOneColorManager.PLAY_OFF);
        this.pageCache.flush();
    }
}

