/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.apcmini.definition;

import de.mossgrabers.controller.akai.apcmini.controller.APCminiButton;
import de.mossgrabers.controller.akai.apcmini.controller.APCminiMk2ColorManager;
import de.mossgrabers.controller.akai.apcmini.definition.AbstractAPCminiDefinition;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.utils.OperatingSystem;
import de.mossgrabers.framework.utils.Pair;
import java.util.List;
import java.util.UUID;

public class APCminiMk2ControllerDefinition
extends AbstractAPCminiDefinition {
    private static final UUID EXTENSION_ID = UUID.fromString("3B953D86-4A53-43B1-BB2C-65A33DC778F1");

    public APCminiMk2ControllerDefinition() {
        super(EXTENSION_ID, "APCmini Mk2");
        this.buttonIDs.put(APCminiButton.TRACK1, 100);
        this.buttonIDs.put(APCminiButton.TRACK2, 101);
        this.buttonIDs.put(APCminiButton.TRACK3, 102);
        this.buttonIDs.put(APCminiButton.TRACK4, 103);
        this.buttonIDs.put(APCminiButton.TRACK5, 104);
        this.buttonIDs.put(APCminiButton.TRACK6, 105);
        this.buttonIDs.put(APCminiButton.TRACK7, 106);
        this.buttonIDs.put(APCminiButton.TRACK8, 107);
        this.buttonIDs.put(APCminiButton.SCENE1, 112);
        this.buttonIDs.put(APCminiButton.SCENE2, 113);
        this.buttonIDs.put(APCminiButton.SCENE3, 114);
        this.buttonIDs.put(APCminiButton.SCENE4, 115);
        this.buttonIDs.put(APCminiButton.SCENE5, 116);
        this.buttonIDs.put(APCminiButton.SCENE6, 117);
        this.buttonIDs.put(APCminiButton.SCENE7, 118);
        this.buttonIDs.put(APCminiButton.SCENE8, 119);
        this.buttonIDs.put(APCminiButton.SHIFT, 122);
    }

    @Override
    public List<Pair<String[], String[]>> getMidiDiscoveryPairs(OperatingSystem os) {
        return this.createDeviceDiscoveryPairs("APC mini mk2");
    }

    @Override
    public int swapShiftedTrackIndices(int trackIndex) {
        return trackIndex < 4 ? trackIndex + 4 : trackIndex - 4;
    }

    @Override
    public int swapShiftedSceneIndices(int sceneIndex) {
        if (sceneIndex == 2) {
            return 3;
        }
        if (sceneIndex == 3) {
            return 2;
        }
        return sceneIndex;
    }

    @Override
    public ColorManager getColorManager() {
        return new APCminiMk2ColorManager();
    }

    @Override
    public boolean hasBrightness() {
        return true;
    }

    @Override
    public boolean hasRGBColors() {
        return true;
    }
}

