/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.apcmini.controller;

import de.mossgrabers.controller.akai.apcmini.APCminiConfiguration;
import de.mossgrabers.controller.akai.apcmini.controller.APCminiPadGrid;
import de.mossgrabers.controller.akai.apcmini.definition.IAPCminiControllerDefinition;
import de.mossgrabers.framework.controller.AbstractControlSurface;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.hardware.BindType;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;

public class APCminiControlSurface
extends AbstractControlSurface<APCminiConfiguration> {
    public static final int APC_KNOB_TRACK_LEVEL1 = 48;
    public static final int APC_KNOB_TRACK_LEVEL2 = 49;
    public static final int APC_KNOB_TRACK_LEVEL3 = 50;
    public static final int APC_KNOB_TRACK_LEVEL4 = 51;
    public static final int APC_KNOB_TRACK_LEVEL5 = 52;
    public static final int APC_KNOB_TRACK_LEVEL6 = 53;
    public static final int APC_KNOB_TRACK_LEVEL7 = 54;
    public static final int APC_KNOB_TRACK_LEVEL8 = 55;
    public static final int APC_KNOB_MASTER_LEVEL = 56;
    public static final int APC_BUTTON_STATE_OFF = 0;
    public static final int APC_BUTTON_STATE_ON = 1;
    public static final int APC_BUTTON_STATE_BLINK = 2;
    public static final int TRACK_STATE_CLIP_STOP = 0;
    public static final int TRACK_STATE_SOLO = 1;
    public static final int TRACK_STATE_REC_ARM = 2;
    public static final int TRACK_STATE_MUTE = 3;
    public static final int TRACK_STATE_SELECT = 4;
    private int trackState = 0;

    public APCminiControlSurface(IHost host, ColorManager colorManager, APCminiConfiguration configuration, IMidiOutput output, IMidiInput input, IAPCminiControllerDefinition definition) {
        super(host, configuration, colorManager, output, input, new APCminiPadGrid(colorManager, output, configuration, definition), 110.0, 106.0);
    }

    @Override
    public void setTrigger(BindType bindType, int channel, int cc, int state) {
        this.output.sendNoteEx(channel, cc, state);
    }

    public int getTrackState() {
        return this.trackState;
    }

    public void setTrackState(int trackState) {
        this.trackState = trackState;
    }
}

