/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.command.trigger;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;

public class PanSendCommand
extends AbstractTriggerCommand<PushControlSurface, PushConfiguration> {
    public PanSendCommand(IModel model, PushControlSurface surface) {
        super(model, surface);
    }

    @Override
    public void execute(ButtonEvent event, int velocity) {
        Modes mode;
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ModeManager modeManager = ((PushControlSurface)this.surface).getModeManager();
        Modes currentMode = (Modes)((Object)modeManager.getActiveIDIgnoreTemporary());
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        if (!config.isPushModern() && ((PushControlSurface)this.surface).isSelectPressed() && Modes.isLayerMode(currentMode)) {
            ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.SELECT);
            Modes mode2 = Modes.get(currentMode, 1);
            if (mode2.ordinal() < Modes.DEVICE_LAYER_PAN.ordinal() || mode2.ordinal() > Modes.DEVICE_LAYER_SEND8.ordinal()) {
                mode2 = Modes.DEVICE_LAYER_PAN;
            }
            modeManager.setActive(mode2);
            return;
        }
        if (currentMode.ordinal() < Modes.SEND1.ordinal() || currentMode.ordinal() > Modes.SEND8.ordinal()) {
            mode = Modes.SEND1;
        } else {
            mode = Modes.get(currentMode, 1);
            if (mode.ordinal() > Modes.SEND8.ordinal()) {
                mode = Modes.PAN;
            }
        }
        ITrackBank tb = this.model.getTrackBank();
        if (mode.ordinal() < Modes.SEND1.ordinal() || mode.ordinal() > Modes.SEND8.ordinal() || !tb.canEditSend(mode.ordinal() - Modes.SEND1.ordinal())) {
            mode = Modes.PAN;
        }
        modeManager.setActive(mode);
    }
}

