/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.device.column;

import de.mossgrabers.reaper.framework.device.DeviceManager;
import de.mossgrabers.reaper.framework.device.DeviceType;
import de.mossgrabers.reaper.framework.device.column.BaseColumn;
import de.mossgrabers.reaper.framework.device.column.BaseColumnItem;
import java.util.ArrayList;
import java.util.List;

public class DeviceTypeFilterColumn
extends BaseColumn {
    public DeviceTypeFilterColumn(int columnIndex, int numFilterColumnEntries) {
        super(columnIndex, "Device Type", numFilterColumnEntries);
        for (int i = 0; i < numFilterColumnEntries; ++i) {
            this.items[i] = new DeviceTypeBrowserColumnItem(i);
        }
    }

    @Override
    protected int getMaxNumItems() {
        return DeviceType.values().length;
    }

    @Override
    public List<String> getAllItems() {
        DeviceType[] type = DeviceType.values();
        ArrayList<String> result = new ArrayList<String>(type.length);
        for (DeviceType location : type) {
            result.add(location.getName());
        }
        return result;
    }

    private class DeviceTypeBrowserColumnItem
    extends BaseColumnItem {
        public DeviceTypeBrowserColumnItem(int index) {
            super(index);
        }

        @Override
        public int getIndex() {
            return DeviceTypeFilterColumn.this.calcPosition(this.index);
        }

        @Override
        public boolean isSelected() {
            return this.getIndex() == DeviceTypeFilterColumn.this.selectedRow;
        }

        @Override
        protected String getCachedName() {
            if (this.position == 0) {
                return "All";
            }
            int pos = this.position - 1;
            DeviceType[] values = DeviceType.values();
            return pos < values.length ? values[pos].getName() : "";
        }

        @Override
        protected int getCachedHitCount() {
            if (this.position == 0) {
                return DeviceManager.get().getNumDevices();
            }
            int pos = this.position - 1;
            DeviceType[] values = DeviceType.values();
            return pos < values.length ? DeviceManager.get().filterByType(values[pos]).size() : 0;
        }
    }
}

