/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.controller.grid;

import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.grid.LightInfo;
import de.mossgrabers.framework.controller.grid.PadGridImpl;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public abstract class BlinkingPadGrid
extends PadGridImpl {
    protected static final int BLINK_SPEED = 600;
    protected final Map<Integer, LightInfo> blinkingLights = new HashMap<Integer, LightInfo>();
    protected final Map<Integer, LightInfo> padInfos = new TreeMap<Integer, LightInfo>();
    protected boolean isBlink;
    protected long updateTime = System.currentTimeMillis();

    protected BlinkingPadGrid(ColorManager colorManager, IMidiOutput output) {
        super(colorManager, output);
    }

    protected BlinkingPadGrid(ColorManager colorManager, IMidiOutput output, int rows, int columns, int startNote) {
        super(colorManager, output, rows, columns, startNote);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Map<Integer, LightInfo> map = this.padInfos;
        synchronized (map) {
            this.updateController();
            this.padInfos.clear();
        }
    }

    protected void updateController() {
        for (Map.Entry<Integer, LightInfo> e : this.padInfos.entrySet()) {
            Integer note = e.getKey();
            LightInfo info = e.getValue();
            this.sendPadUpdate(note, info.getColor());
            if (info.getBlinkColor() > 0) {
                this.blinkingLights.put(note, info);
                continue;
            }
            this.blinkingLights.remove(note);
        }
        if (!this.checkBlinking()) {
            return;
        }
        for (Map.Entry<Integer, LightInfo> value : this.blinkingLights.entrySet()) {
            LightInfo info = value.getValue();
            int colorIndex = this.isBlink ? info.getBlinkColor() : info.getColor();
            int note = value.getKey();
            this.sendPadUpdate(note, colorIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendNoteState(int channel, int note, int color) {
        Map<Integer, LightInfo> map = this.padInfos;
        synchronized (map) {
            this.padInfos.computeIfAbsent(note, key -> new LightInfo()).setColor(color);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendBlinkState(int channel, int note, int blinkColor, boolean fast) {
        Map<Integer, LightInfo> map = this.padInfos;
        synchronized (map) {
            LightInfo info = this.padInfos.computeIfAbsent(note, key -> new LightInfo());
            info.setBlinkColor(blinkColor);
            info.setFast(fast);
        }
    }

    protected boolean checkBlinking() {
        long now = System.currentTimeMillis();
        if (now - this.updateTime > 600L) {
            this.updateTime = now;
            this.isBlink = !this.isBlink;
            return true;
        }
        return false;
    }

    protected void sendPadUpdate(int note, int colorIndex) {
        this.output.sendNoteEx(0, note, colorIndex);
    }
}

