/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchkey.maxi.controller;

import de.mossgrabers.framework.controller.display.AbstractTextDisplay;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.utils.StringUtils;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.UnsupportedCharsetException;

public class LaunchkeyMk3Display
extends AbstractTextDisplay {
    private String sysexDisplayHeaderBase = "F0 00 20 29 02 0F 04 ";
    private String sysexDisplayHeaderParamName = "F0 00 20 29 02 0F 07 ";
    private String sysexDisplayHeaderParamValue = "F0 00 20 29 02 0F 08 ";
    public static final int SCREEN_ROW_BASE = 0;
    public static final int SCREEN_ROW_POTS = 2;
    public static final int SCREEN_ROW_FADERS = 18;
    private static final int SCREEN_ID_POT1 = 56;
    private static final int SCREEN_ID_FADER1 = 80;
    private CharsetEncoder isoEncoder;

    public LaunchkeyMk3Display(IHost host, IMidiOutput output) {
        super(host, output, 36, 1, 16);
        try {
            this.isoEncoder = Charset.forName("ISO-8859-2").newEncoder();
        }
        catch (UnsupportedCharsetException ex) {
            this.isoEncoder = null;
        }
        this.setCenterNotification(false);
    }

    @Override
    public void writeLine(int row, String text, String previousText) {
        StringBuilder sb = new StringBuilder();
        if (row < 2) {
            sb.append(this.sysexDisplayHeaderBase).append(StringUtils.toHexStr(row)).append(' ');
        } else {
            sb.append(row % 2 == 0 ? this.sysexDisplayHeaderParamName : this.sysexDisplayHeaderParamValue);
            if (row < 18) {
                index = (row - 2) / 2;
                sb.append(StringUtils.toHexStr(56 + index));
            } else {
                index = (row - 18) / 2;
                sb.append(StringUtils.toHexStr(80 + index));
            }
            sb.append(' ');
        }
        if (this.isoEncoder == null) {
            sb.append(StringUtils.asciiToHex(StringUtils.pad(StringUtils.fixASCII(text), 16)));
        } else {
            for (int i = 0; i < text.length(); ++i) {
                char character = text.charAt(i);
                if (!this.isoEncoder.canEncode(character)) continue;
                if (character > '\u007f') {
                    sb.append("11 ").append(StringUtils.toHexStr(character - 128)).append(' ');
                    continue;
                }
                sb.append(StringUtils.toHexStr(character)).append(' ');
            }
        }
        this.output.sendSysex(sb.append("F7").toString());
    }

    @Override
    public void shutdown() {
    }

    public void setModel(boolean is88KeyVersion) {
        if (is88KeyVersion) {
            this.sysexDisplayHeaderBase = "F0 00 20 29 02 12 04 ";
            this.sysexDisplayHeaderParamName = "F0 00 20 29 02 12 07 ";
            this.sysexDisplayHeaderParamValue = "F0 00 20 29 02 12 08 ";
            this.forceFlush();
        }
    }
}

