/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.mk3.view;

import de.mossgrabers.controller.ni.maschine.mk3.MaschineConfiguration;
import de.mossgrabers.controller.ni.maschine.mk3.controller.MaschineControlSurface;
import de.mossgrabers.controller.ni.maschine.mk3.view.DrumView;
import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.display.IDisplay;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.controller.hardware.IHwButton;
import de.mossgrabers.framework.daw.DAWColor;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.IStepInfo;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.daw.clip.StepState;
import de.mossgrabers.framework.daw.constants.Resolution;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.featuregroup.IMode;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.INoteEditor;
import de.mossgrabers.framework.mode.INoteEditorMode;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractPlayView;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.IntUnaryOperator;

public class PlayView
extends AbstractPlayView<MaschineControlSurface, MaschineConfiguration> {
    private static final int SEQUENCER_STEPS = 16;
    private final DrumView drumView;
    private final MaschineConfiguration configuration;
    private final int numColumns;
    private boolean isShifted = false;
    private int selectedNote = -1;
    private IStepInfo copyNote;
    private boolean isChordActive;

    public PlayView(MaschineControlSurface surface, IModel model, DrumView drumView) {
        super(surface, model, true);
        this.drumView = drumView;
        this.numColumns = 4;
        this.configuration = (MaschineConfiguration)surface.getConfiguration();
        PlayView playView = this;
        this.configuration.addSettingObserver(AbstractConfiguration.ACTIVATE_FIXED_ACCENT, () -> playView.initMaxVelocity());
        playView = this;
        this.configuration.addSettingObserver(AbstractConfiguration.FIXED_ACCENT_VALUE, () -> playView.initMaxVelocity());
    }

    public void toggleChordMode() {
        this.isChordActive = !this.isChordActive;
    }

    public boolean isChordMode() {
        return this.isChordActive;
    }

    public void toggleShifted() {
        this.isShifted = !this.isShifted;
        this.updateNoteMapping();
    }

    @Override
    public void updateControlSurface() {
        this.drumView.setSequencerActive(this.model.canSelectedTrackHoldNotes() && this.drumView.getClip().doesExist());
        super.updateControlSurface();
    }

    @Override
    public void updateNoteMapping() {
        if (this.isShifted) {
            this.delayedUpdateNoteMapping(EMPTY_TABLE);
        } else {
            super.updateNoteMapping();
        }
    }

    @Override
    public void drawGrid() {
        if (this.drumView.isGridEditor()) {
            this.drumView.drawGrid();
            return;
        }
        if (this.drumView.isSequencerVisible()) {
            INoteClip clip = this.drumView.getClip();
            boolean isActive = this.model.canSelectedTrackHoldNotes();
            this.drawSequencerSteps(clip, isActive, this.selectedNote, y -> 3 - y);
            return;
        }
        if (this.isShifted) {
            this.drawShiftedGrid();
            return;
        }
        super.drawGrid();
    }

    protected void drawSequencerSteps(INoteClip clip, boolean isActive, int noteRow, IntUnaryOperator yModifier) {
        int step = clip.getCurrentStep();
        int hiStep = this.isInXRange(step) ? step % 16 : -1;
        int channel = this.configuration.getMidiEditChannel();
        NotePosition notePosition = new NotePosition(channel, 0, noteRow);
        List<NotePosition> editNotes = this.getEditNotes();
        IPadGrid padGrid = ((MaschineControlSurface)this.surface).getPadGrid();
        for (int col = 0; col < 16; ++col) {
            notePosition.setStep(col);
            int x = col % this.numColumns;
            int y = col / this.numColumns;
            if (yModifier != null) {
                y = yModifier.applyAsInt(y);
            }
            if (noteRow == -1) {
                padGrid.lightEx(x, y, "COLOR_NO_CONTENT");
                continue;
            }
            IStepInfo stepInfo = clip.getStep(notePosition);
            boolean hilite = col == hiStep;
            padGrid.lightEx(x, y, this.getStepColor(isActive, stepInfo, hilite, notePosition, editNotes));
        }
    }

    protected boolean isInXRange(int x) {
        INoteClip clip = this.drumView.getClip();
        int stepSize = clip.getNumSteps();
        int start = clip.getEditPage() * stepSize;
        return x >= start && x < start + stepSize;
    }

    protected String getStepColor(boolean isActive, IStepInfo stepInfo, boolean hilite, NotePosition notePosition, List<NotePosition> editNotes) {
        if (!isActive) {
            return "COLOR_NO_CONTENT";
        }
        Optional track = this.model.getCurrentTrackBank().getSelectedItem();
        switch (stepInfo.getState()) {
            case START: {
                if (hilite) {
                    return "COLOR_STEP_HILITE_CONTENT";
                }
                if (PlayView.isEdit(notePosition, editNotes)) {
                    return "COLOR_STEP_SELECTED";
                }
                if (stepInfo.isMuted()) {
                    return "COLOR_STEP_MUTED";
                }
                return track.isPresent() ? DAWColor.getColorID(ColorEx.darker(((ITrack)track.get()).getColor())) : "COLOR_CONTENT";
            }
            case CONTINUE: {
                if (hilite) {
                    return "COLOR_STEP_HILITE_CONTENT";
                }
                if (PlayView.isEdit(notePosition, editNotes)) {
                    return "COLOR_STEP_SELECTED";
                }
                if (stepInfo.isMuted()) {
                    return "COLOR_STEP_MUTED_CONT";
                }
                return track.isPresent() ? DAWColor.getColorID(ColorEx.darker(((ITrack)track.get()).getColor())) : "COLOR_CONTENT_CONT";
            }
        }
        if (hilite) {
            return "COLOR_STEP_HILITE_NO_CONTENT";
        }
        return "COLOR_NO_CONTENT";
    }

    private void drawShiftedGrid() {
        int i;
        boolean isKeyboardEnabled = this.model.canSelectedTrackHoldNotes();
        IPadGrid padGrid = ((MaschineControlSurface)this.surface).getPadGrid();
        Scales scales = this.model.getScales();
        padGrid.light(36, scales.isChromatic() ? 58 : 57);
        for (i = 37; i < 40; ++i) {
            padGrid.light(i, 0);
        }
        for (i = 40; i < 42; ++i) {
            padGrid.light(i, isKeyboardEnabled ? 42 : 0);
        }
        for (i = 42; i < 44; ++i) {
            padGrid.light(i, 0);
        }
        for (i = 44; i < 46; ++i) {
            padGrid.light(i, isKeyboardEnabled ? 30 : 0);
        }
        for (i = 46; i < 48; ++i) {
            padGrid.light(i, 0);
        }
        for (i = 48; i < 50; ++i) {
            padGrid.light(i, isKeyboardEnabled ? 7 : 0);
        }
        for (i = 50; i < 52; ++i) {
            padGrid.light(i, isKeyboardEnabled ? 11 : 0);
        }
    }

    @Override
    public void onGridNote(int key, int velocity) {
        if (!this.model.canSelectedTrackHoldNotes()) {
            return;
        }
        if (this.drumView.isGridEditor()) {
            this.drumView.onGridNote(key, velocity);
            return;
        }
        int index = key - 36;
        if (this.drumView.isSequencerVisible()) {
            int x = index % this.numColumns;
            int y = index / this.numColumns;
            if (this.model.canSelectedTrackHoldNotes()) {
                this.handleSequencerArea(index, x, 3 - y, velocity);
            }
            return;
        }
        if (!this.isShifted) {
            super.onGridNote(key, velocity);
            int note = this.keyManager.map(key);
            if (note != -1) {
                this.keyManager.setAllKeysPressed(note, velocity);
                this.selectedNote = note;
                if (this.isChordActive) {
                    int[] thirdChord = this.scales.getThirdChord(note);
                    if (thirdChord.length == 0) {
                        return;
                    }
                    IMidiInput input = ((MaschineControlSurface)this.surface).getMidiInput();
                    int channel = this.configuration.getMidiEditChannel();
                    input.sendRawMidiEvent(144 + channel, thirdChord[0], velocity);
                    input.sendRawMidiEvent(144 + channel, thirdChord[1], velocity);
                }
            }
            return;
        }
        if (velocity == 0) {
            return;
        }
        IDisplay display = ((MaschineControlSurface)this.surface).getDisplay();
        switch (index) {
            case 0: {
                this.scales.toggleChromatic();
                display.notify("Chromatic: " + (this.scales.isChromatic() ? "On" : "Off"));
                this.configuration.setScaleInKey(!this.scales.isChromatic());
                break;
            }
            case 4: {
                this.scales.prevScaleLayout();
                display.notify(this.scales.getScaleLayout().getName());
                break;
            }
            case 5: {
                this.scales.nextScaleLayout();
                display.notify(this.scales.getScaleLayout().getName());
                break;
            }
            case 8: {
                this.scales.prevScaleOffset();
                display.notify(Scales.BASES.get(this.scales.getScaleOffsetIndex()));
                break;
            }
            case 9: {
                this.scales.nextScaleOffset();
                display.notify(Scales.BASES.get(this.scales.getScaleOffsetIndex()));
                break;
            }
            case 12: {
                this.scales.prevScale();
                display.notify(this.scales.getScale().getName());
                break;
            }
            case 13: {
                this.scales.nextScale();
                display.notify(this.scales.getScale().getName());
                break;
            }
            case 14: {
                this.onOctaveDown(ButtonEvent.DOWN);
                break;
            }
            case 15: {
                this.onOctaveUp(ButtonEvent.DOWN);
                break;
            }
        }
        this.update();
    }

    protected void handleSequencerArea(int index, int x, int y, int velocity) {
        int vel;
        int step;
        int channel;
        NotePosition notePosition;
        if (this.selectedNote == -1 || velocity != 0) {
            return;
        }
        INoteClip clip = this.drumView.getClip();
        if (this.handleSequencerAreaButtonCombinations(clip, notePosition = new NotePosition(channel = this.configuration.getMidiEditChannel(), step = this.numColumns * (3 - y) + x, this.selectedNote), vel = this.configuration.isAccentActive() ? this.configuration.getFixedAccentValue() : ((MaschineControlSurface)this.surface).getButton(ButtonID.get(ButtonID.PAD1, index)).getPressedVelocity())) {
            return;
        }
        clip.toggleStep(notePosition, vel);
    }

    protected boolean handleSequencerAreaButtonCombinations(INoteClip clip, NotePosition notePosition, int velocity) {
        if (this.isButtonCombination(ButtonID.MUTE)) {
            IStepInfo noteStep = clip.getStep(notePosition);
            if (noteStep.getState() == StepState.START) {
                clip.updateStepMuteState(notePosition, !noteStep.isMuted());
            }
            return true;
        }
        if (((MaschineControlSurface)this.surface).getModeManager().isActive(new Modes[]{Modes.NOTE})) {
            this.model.getHost().showNotification("Note " + Scales.formatNoteAndOctave(notePosition.getNote(), -3) + " - Step " + Integer.toString(notePosition.getStep() + 1));
            this.editNote(clip, notePosition, true);
            return true;
        }
        IHwButton duplicateButton = ((MaschineControlSurface)this.surface).getButton(ButtonID.DUPLICATE);
        if (duplicateButton != null && duplicateButton.isPressed()) {
            duplicateButton.setConsumed();
            IStepInfo noteStep = clip.getStep(notePosition);
            if (noteStep.getState() == StepState.START) {
                this.copyNote = noteStep;
            } else if (this.copyNote != null) {
                clip.setStep(notePosition, this.copyNote);
            }
            return true;
        }
        NotePosition np = new NotePosition(notePosition);
        int step = np.getStep();
        int note = np.getNote();
        for (int s = step - 1; s >= 0; --s) {
            StepState state;
            np.setStep(s);
            int x = s % this.numColumns;
            int y = s / this.numColumns;
            int pad = y * this.numColumns + x;
            IHwButton button = ((MaschineControlSurface)this.surface).getButton(ButtonID.get(ButtonID.PAD1, pad));
            if (!button.isLongPressed()) continue;
            button.setConsumed();
            int length = step - s + 1;
            double duration = (double)length * Resolution.getValueAt(this.drumView.getResolutionIndex());
            StepState stepState = state = note < 0 ? StepState.OFF : clip.getStep(np).getState();
            if (state == StepState.START) {
                clip.updateStepDuration(np, duration);
            } else {
                clip.setStep(np, velocity, duration);
            }
            return true;
        }
        return false;
    }

    private void update() {
        this.updateNoteMapping();
        this.scales.updateScaleProperties(this.configuration);
    }

    protected List<NotePosition> getEditNotes() {
        ModeManager modeManager = ((MaschineControlSurface)this.surface).getModeManager();
        IMode mode = (IMode)modeManager.get(Modes.NOTE);
        if (mode instanceof INoteEditorMode) {
            INoteEditorMode noteMode = (INoteEditorMode)((Object)mode);
            return noteMode.getNoteEditor().getNotes();
        }
        return Collections.emptyList();
    }

    protected static boolean isEdit(NotePosition notePosition, List<NotePosition> editNotes) {
        for (NotePosition editNote : editNotes) {
            if (!editNote.equals(notePosition)) continue;
            return true;
        }
        return false;
    }

    protected void editNote(INoteClip clip, NotePosition notePosition, boolean addNote) {
        StepState state = clip.getStep(notePosition).getState();
        if (state != StepState.START) {
            return;
        }
        ModeManager modeManager = ((MaschineControlSurface)this.surface).getModeManager();
        IMode mode = (IMode)modeManager.get(Modes.NOTE);
        if (mode instanceof INoteEditorMode) {
            INoteEditorMode noteMode = (INoteEditorMode)((Object)mode);
            INoteEditor noteEditor = noteMode.getNoteEditor();
            if (addNote) {
                noteEditor.addNote(clip, notePosition);
            } else {
                noteEditor.setNote(clip, notePosition);
            }
            modeManager.setActive(Modes.NOTE);
        }
    }
}

