/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.jam.view;

import de.mossgrabers.controller.ni.maschine.core.command.trigger.EncoderMode;
import de.mossgrabers.controller.ni.maschine.core.view.IMaschineView;
import de.mossgrabers.controller.ni.maschine.jam.MaschineJamConfiguration;
import de.mossgrabers.controller.ni.maschine.jam.controller.MaschineJamControlSurface;
import de.mossgrabers.controller.ni.maschine.jam.view.IViewNavigation;
import de.mossgrabers.framework.command.trigger.Direction;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.sequencer.AbstractDrumView;

public class DrumView
extends AbstractDrumView<MaschineJamControlSurface, MaschineJamConfiguration>
implements IMaschineView,
IViewNavigation {
    public DrumView(MaschineJamControlSurface surface, IModel model) {
        super("Drum", surface, model, 4, 4, true);
    }

    @Override
    public void changeOption(EncoderMode temporaryEncoderMode, int control) {
        this.keyManager.clearPressedKeys();
        boolean increase = this.model.getValueChanger().isIncrease(control);
        switch (temporaryEncoderMode) {
            case TEMPORARY_PERFORM: {
                break;
            }
            case TEMPORARY_NOTES: {
                break;
            }
            case TEMPORARY_LOCK: {
                break;
            }
            case TEMPORARY_TUNE: {
                if (increase) {
                    this.onOctaveUp(ButtonEvent.DOWN);
                    break;
                }
                this.onOctaveDown(ButtonEvent.DOWN);
                break;
            }
        }
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        switch (buttonID) {
            case ARROW_LEFT: {
                this.onLeft(event);
                break;
            }
            case ARROW_RIGHT: {
                this.onRight(event);
                break;
            }
            case ARROW_UP: {
                this.onOctaveUp(event);
                break;
            }
            case ARROW_DOWN: {
                this.onOctaveDown(event);
                break;
            }
            default: {
                super.onButton(buttonID, event, velocity);
            }
        }
    }

    @Override
    public boolean canScroll(Direction direction) {
        INoteClip clip = this.getClip();
        switch (direction) {
            case LEFT: {
                return clip.canScrollStepsBackwards();
            }
            case RIGHT: {
                return clip.canScrollStepsForwards();
            }
            case UP: {
                return this.isOctaveUpButtonOn();
            }
            case DOWN: {
                return this.isOctaveDownButtonOn();
            }
        }
        return false;
    }

    @Override
    protected boolean handleSequencerAreaButtonCombinations(INoteClip clip, NotePosition notePosition, int velocity) {
        boolean isSelectPressed = ((MaschineJamControlSurface)this.surface).isSelectPressed();
        if (isSelectPressed) {
            if (velocity > 0) {
                this.handleSequencerAreaRepeatOperator(clip, notePosition, velocity, isSelectPressed);
            }
            return true;
        }
        return super.handleSequencerAreaButtonCombinations(clip, notePosition, velocity);
    }

    @Override
    public boolean wasAlternateInteractionUsed() {
        return false;
    }

    @Override
    public void setAlternateInteractionUsed(boolean wasUsed) {
    }
}

