/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.kontrol.mkii;

import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.configuration.IEnumSetting;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.ArpeggiatorMode;
import java.util.List;

public class KontrolProtocolConfiguration
extends AbstractConfiguration {
    private static final Integer FLIP_TRACK_CLIP_NAVIGATION = 100;
    private static final Integer FLIP_CLIP_SCENE_NAVIGATION = 101;
    public static final Integer DAW_SWITCH = 102;
    private static final String CATEGORY_NAVIGATION = "Navigation";
    private static final String[] DAW_NAMES = new String[]{"Generic", "Bitwig", "Cubase", "Live", "Digital Performer", "Logic Pro"};
    private final int version;
    private boolean flipTrackClipNavigation = false;
    private boolean flipClipSceneNavigation = false;
    private int dawNameIndex = 0;

    public KontrolProtocolConfiguration(IHost host, IValueChanger valueChanger, List<ArpeggiatorMode> arpeggiatorModes, int version) {
        super(host, valueChanger, arpeggiatorModes);
        this.version = version;
    }

    @Override
    public void init(ISettingsUI globalSettings, ISettingsUI documentSettings) {
        if (this.version >= 3) {
            IEnumSetting modeSwitchButtonSetting = globalSettings.getEnumSetting("Device Background (requires restart)", "Hardware Setup", DAW_NAMES, DAW_NAMES[1]);
            modeSwitchButtonSetting.addValueObserver(value -> {
                this.dawNameIndex = KontrolProtocolConfiguration.lookupIndex(DAW_NAMES, value);
                this.notifyObservers(DAW_SWITCH);
            });
            this.isSettingActive.add(DAW_SWITCH);
        }
        this.activateBehaviourOnStopSetting(globalSettings);
        this.activateBehaviourOnPauseSetting(globalSettings);
        this.activateRecordButtonSetting(globalSettings);
        this.activateShiftedRecordButtonSetting(globalSettings);
        IEnumSetting flipTrackClipNavigationSetting = globalSettings.getEnumSetting("Flip track/clip navigation", CATEGORY_NAVIGATION, ON_OFF_OPTIONS, ON_OFF_OPTIONS[0]);
        flipTrackClipNavigationSetting.addValueObserver(value -> {
            this.flipTrackClipNavigation = ON_OFF_OPTIONS[1].equals(value);
            this.notifyObservers(FLIP_TRACK_CLIP_NAVIGATION);
        });
        this.isSettingActive.add(FLIP_TRACK_CLIP_NAVIGATION);
        IEnumSetting flipClipSceneNavigationSetting = globalSettings.getEnumSetting("Flip clip/scene navigation", CATEGORY_NAVIGATION, ON_OFF_OPTIONS, ON_OFF_OPTIONS[0]);
        flipClipSceneNavigationSetting.addValueObserver(value -> {
            this.flipClipSceneNavigation = ON_OFF_OPTIONS[1].equals(value);
            this.notifyObservers(FLIP_CLIP_SCENE_NAVIGATION);
        });
        this.isSettingActive.add(FLIP_CLIP_SCENE_NAVIGATION);
        this.activateExcludeDeactivatedItemsSetting(globalSettings);
        this.activateNewClipLengthSetting(globalSettings);
        this.activateKnobSpeedSetting(globalSettings, 30, 0);
    }

    public boolean isFlipTrackClipNavigation() {
        return this.flipTrackClipNavigation;
    }

    public boolean isFlipClipSceneNavigation() {
        return this.flipClipSceneNavigation;
    }

    public String getSelectedDaw() {
        return DAW_NAMES[this.dawNameIndex];
    }
}

