/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.gamepad.controller;

import com.studiohartman.jamepad.ControllerAxis;
import com.studiohartman.jamepad.ControllerButton;
import com.studiohartman.jamepad.ControllerIndex;
import com.studiohartman.jamepad.ControllerManager;
import com.studiohartman.jamepad.ControllerUnpluggedException;
import de.mossgrabers.controller.gamepad.controller.IGamepadCallback;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.utils.ButtonEvent;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class GamepadControllerInputThread
implements Runnable {
    private static final long INTERVAL = 1L;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final IHost host;
    private final ControllerManager gamepadManager;
    private final IGamepadCallback gamepadCallback;
    private final Map<ControllerButton, Boolean> buttonStates = new EnumMap<ControllerButton, Boolean>(ControllerButton.class);
    private final Map<ControllerAxis, Float> axisStates = new EnumMap<ControllerAxis, Float>(ControllerAxis.class);
    private int selectedController = -1;

    public GamepadControllerInputThread(IHost host, ControllerManager gamepadManager, IGamepadCallback gamepadCallback) {
        this.host = host;
        this.gamepadManager = gamepadManager;
        this.gamepadCallback = gamepadCallback;
    }

    public void start() {
        new Thread(this).start();
    }

    public void stop() {
        this.running.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectController(int controllerIndex) {
        ControllerManager controllerManager = this.gamepadManager;
        synchronized (controllerManager) {
            ControllerIndex gamepad;
            if (this.selectedController >= 0 && (gamepad = this.gamepadManager.getControllerIndex(this.selectedController)).isConnected()) {
                gamepad.close();
            }
            this.selectedController = controllerIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.running.set(true);
        try {
            while (this.running.get()) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                if (!this.running.get()) {
                    return;
                }
                ControllerManager ex = this.gamepadManager;
                synchronized (ex) {
                    if (this.selectedController < 0 || this.selectedController >= this.gamepadManager.getNumControllers()) {
                        continue;
                    }
                    ControllerIndex currController = this.gamepadManager.getControllerIndex(this.selectedController);
                    if (!currController.isConnected()) {
                        this.gamepadManager.update();
                        if (this.selectedController >= 0 && this.selectedController < this.gamepadManager.getNumControllers()) {
                            currController.reconnectController();
                        }
                        continue;
                    }
                    try {
                        Comparable<Boolean> state;
                        for (ControllerButton controllerButton : ControllerButton.values()) {
                            boolean isPressed = currController.isButtonPressed(controllerButton);
                            state = this.buttonStates.getOrDefault(controllerButton, Boolean.FALSE);
                            if ((Boolean)state == isPressed) continue;
                            this.buttonStates.put(controllerButton, isPressed);
                            this.host.scheduleTask(() -> this.gamepadCallback.process(controllerButton, isPressed ? ButtonEvent.DOWN : ButtonEvent.UP), 0L);
                        }
                        for (ControllerButton controllerButton : ControllerAxis.values()) {
                            float position = currController.getAxisState((ControllerAxis)controllerButton);
                            state = this.axisStates.getOrDefault(controllerButton, Float.valueOf(0.0f));
                            if (((Float)state).floatValue() == position) continue;
                            this.axisStates.put((ControllerAxis)controllerButton, Float.valueOf(position));
                            this.host.scheduleTask(() -> this.lambda$run$1((ControllerAxis)controllerButton, position), 0L);
                        }
                    }
                    catch (ControllerUnpluggedException ex2) {
                        this.host.error("Controller not connected.");
                    }
                }
            }
            return;
        }
        catch (RuntimeException ex) {
            this.host.error("Controller error.", ex);
        }
    }

    private /* synthetic */ void lambda$run$1(ControllerAxis axis, float position) {
        this.gamepadCallback.process(axis, position);
    }
}

