/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.apc.mode;

import de.mossgrabers.controller.akai.apc.controller.APCControlSurface;
import de.mossgrabers.controller.akai.apc.mode.BaseMode;
import de.mossgrabers.framework.controller.display.IDisplay;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.featuregroup.IView;
import de.mossgrabers.framework.mode.INoteEditor;
import de.mossgrabers.framework.mode.INoteEditorMode;
import de.mossgrabers.framework.mode.NoteEditor;
import de.mossgrabers.framework.parameter.NoteAttribute;
import de.mossgrabers.framework.parameter.NoteParameter;
import de.mossgrabers.framework.parameterprovider.special.FixedParameterProvider;
import de.mossgrabers.framework.view.sequencer.AbstractSequencerView;

public class NoteMode
extends BaseMode<IItem>
implements INoteEditorMode {
    private final NoteEditor noteEditor = new NoteEditor();
    private final FixedParameterProvider fixedParameterProvider;

    public NoteMode(APCControlSurface surface, IModel model) {
        super("Note Edit", surface, model, 2, null);
        IValueChanger valueChanger = model.getValueChanger();
        IDisplay display = surface.getDisplay();
        this.fixedParameterProvider = new FixedParameterProvider(new NoteParameter(NoteAttribute.DURATION, display, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.VELOCITY, display, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.VELOCITY_SPREAD, display, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.GAIN, display, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.PANNING, display, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.CHANCE, display, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.TIMBRE, display, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.PRESSURE, display, model, this.noteEditor, valueChanger));
    }

    public void setValues(INoteClip clip, NotePosition notePosition) {
        this.noteEditor.setNote(clip, notePosition);
    }

    @Override
    public void setValue(int index, int value) {
        this.fixedParameterProvider.get(index).setValue(value);
        IView activeView = (IView)((APCControlSurface)this.surface).getViewManager().getActive();
        if (activeView instanceof AbstractSequencerView) {
            AbstractSequencerView sequencerView = (AbstractSequencerView)activeView;
            sequencerView.setNoteEdited();
        }
    }

    @Override
    public int getKnobValue(int index) {
        return this.fixedParameterProvider.get(index).getValue();
    }

    @Override
    public INoteEditor getNoteEditor() {
        return this.noteEditor;
    }
}

