/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.mode.track;

import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.controller.ableton.push.mode.track.AbstractTrackMode;
import de.mossgrabers.framework.controller.display.Format;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.parameterprovider.track.PanParameterProvider;

public class PanMode
extends AbstractTrackMode {
    public PanMode(PushControlSurface surface, IModel model) {
        super("Panning", surface, model);
        this.setParameterProvider(new PanParameterProvider(model));
    }

    @Override
    public void updateDisplay1(ITextDisplay display) {
        ITrackBank tb = this.model.getCurrentTrackBank();
        for (int i = 0; i < 8; ++i) {
            ITrack t = (ITrack)tb.getItem(i);
            display.setCell(0, i, t.doesExist() ? "Pan" : "").setCell(1, i, t.getPanStr(8));
            if (!t.doesExist()) continue;
            display.setCell(2, i, t.getPan(), Format.FORMAT_PAN);
        }
        this.drawRow4(display);
    }

    @Override
    public void updateDisplay2(IGraphicDisplay display) {
        this.updateChannelDisplay(display, 2, false, true);
    }
}

