/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.mode;

import de.mossgrabers.controller.ableton.push.controller.Push1Display;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.controller.ableton.push.mode.BaseMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.display.Format;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.daw.resource.ChannelType;
import de.mossgrabers.framework.parameterprovider.special.CombinedParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.EmptyParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.FixedParameterProvider;
import de.mossgrabers.framework.utils.ButtonEvent;

public class MetronomeMode
extends BaseMode<IItem> {
    private static final int[] PREROLL_MEASURE = new int[]{0, 1, 2, 4};
    private static final String[] PREROLL_NAMES = new String[]{"None", "1 Bar", "2 Bars", "4 Bars"};
    private final ITransport transport;

    public MetronomeMode(PushControlSurface surface, IModel model) {
        super("Transport", surface, model);
        this.transport = this.model.getTransport();
        this.setParameterProvider(new CombinedParameterProvider(new EmptyParameterProvider(7), new FixedParameterProvider(this.model.getTransport().getMetronomeVolumeParameter())));
    }

    @Override
    public void onFirstRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        if (index < PREROLL_MEASURE.length) {
            this.transport.setPrerollMeasures(PREROLL_MEASURE[index]);
        } else if (index == 5) {
            this.transport.togglePrerollMetronome();
        }
    }

    @Override
    public String getButtonColorID(ButtonID buttonID) {
        int index = this.isButtonRow(0, buttonID);
        if (index >= 0) {
            int prerollMeasures = this.transport.getPrerollMeasures();
            if (index < PREROLL_MEASURE.length) {
                return PREROLL_MEASURE[index] == prerollMeasures ? "BUTTON_COLOR_HI" : "BUTTON_COLOR_ON";
            }
            if (index == 5) {
                return this.transport.isPrerollMetronomeEnabled() ? "BUTTON_COLOR2_HI" : "BUTTON_COLOR_ON";
            }
        }
        return "BUTTON_COLOR_OFF";
    }

    @Override
    public void updateDisplay1(ITextDisplay display) {
        display.setBlock(2, 0, "Pre-roll");
        int prerollMeasures = this.transport.getPrerollMeasures();
        for (int i = 0; i < PREROLL_MEASURE.length; ++i) {
            display.setCell(3, i, (PREROLL_MEASURE[i] == prerollMeasures ? Push1Display.SELECT_ARROW : "") + PREROLL_NAMES[i]);
        }
        display.setCell(0, 7, "Volume");
        display.setCell(1, 7, this.transport.getMetronomeVolumeStr());
        display.setCell(2, 7, this.transport.getMetronomeVolume(), Format.FORMAT_VALUE);
        display.setBlock(1, 2, "Play Metronome").setBlock(2, 2, "during Pre-roll?");
        display.setCell(3, 5, this.transport.isPrerollMetronomeEnabled() ? "  Yes" : "  No");
    }

    @Override
    public void updateDisplay2(IGraphicDisplay display) {
        int prerollMeasures = this.transport.getPrerollMeasures();
        for (int i = 0; i < PREROLL_MEASURE.length; ++i) {
            display.addOptionElement("", "", false, i == 0 ? "Pre-roll" : "", PREROLL_NAMES[i], PREROLL_MEASURE[i] == prerollMeasures, false);
        }
        display.addEmptyElement();
        display.addOptionElement("Play Metronome", "", false, "during Pre-Roll?", this.transport.isPrerollMetronomeEnabled() ? "Yes" : "No", this.transport.isPrerollMetronomeEnabled(), false);
        display.addEmptyElement();
        int metronomeVolume = this.transport.getMetronomeVolume();
        display.addParameterElement("", false, "", ChannelType.AUDIO, null, false, "Volume", metronomeVolume, this.transport.getMetronomeVolumeStr(), false, metronomeVolume);
    }
}

