/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.mode;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.IBank;
import de.mossgrabers.framework.featuregroup.AbstractParameterMode;
import de.mossgrabers.framework.utils.ButtonEvent;

public abstract class BaseMode<B extends IItem>
extends AbstractParameterMode<PushControlSurface, PushConfiguration, B> {
    protected static final int SCROLL_RATE = 8;
    protected final boolean isPushModern = ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isPushModern();
    private int movementCounter = 0;

    protected BaseMode(String name, PushControlSurface surface, IModel model) {
        this(name, surface, model, null);
    }

    protected BaseMode(String name, PushControlSurface surface, IModel model, IBank<B> bank) {
        super(name, surface, model, true, bank, DEFAULT_KNOB_IDS);
    }

    @Override
    public void updateDisplay() {
        if (((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isPushModern()) {
            IGraphicDisplay display = ((PushControlSurface)this.surface).getGraphicsDisplay();
            this.updateDisplay2(display);
            display.send();
            return;
        }
        ITextDisplay display = ((PushControlSurface)this.surface).getTextDisplay().clear();
        this.updateDisplay1(display);
        display.allDone();
    }

    public abstract void updateDisplay1(ITextDisplay var1);

    public abstract void updateDisplay2(IGraphicDisplay var1);

    @Override
    public void onButton(int row, int index, ButtonEvent event) {
        if (row == 0) {
            this.onFirstRow(index, event);
        } else {
            this.onSecondRow(index, event);
        }
    }

    public void onFirstRow(int index, ButtonEvent event) {
        if (event == ButtonEvent.UP) {
            ((ITrack)this.model.getCurrentTrackBank().getItem(index)).select();
        }
    }

    public void onSecondRow(int index, ButtonEvent event) {
    }

    protected void checkStopAutomationOnKnobRelease(boolean isTouched) {
        if (!((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isStopAutomationOnKnobRelease() || isTouched) {
            return;
        }
        ITransport transport = this.model.getTransport();
        if (transport.isWritingArrangerAutomation()) {
            transport.toggleWriteArrangerAutomation();
        }
        if (transport.isWritingClipLauncherAutomation()) {
            transport.toggleWriteClipLauncherAutomation();
        }
    }

    protected boolean increaseKnobMovement() {
        ++this.movementCounter;
        if (this.movementCounter < 8) {
            return false;
        }
        this.movementCounter = 0;
        return true;
    }
}

