/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc.transport.udp;

import com.illposed.osc.LibraryInfo;
import com.illposed.osc.OSCPacket;
import com.illposed.osc.OSCParseException;
import com.illposed.osc.OSCSerializeException;
import com.illposed.osc.OSCSerializerAndParserBuilder;
import com.illposed.osc.transport.Transport;
import com.illposed.osc.transport.channel.OSCDatagramChannel;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;

public class UDPTransport
implements Transport {
    public static final int BUFFER_SIZE = 65507;
    private final ByteBuffer buffer = ByteBuffer.allocate(65507);
    private final SocketAddress local;
    private final SocketAddress remote;
    private final DatagramChannel channel;
    private final OSCDatagramChannel oscChannel;

    public UDPTransport(SocketAddress local, SocketAddress remote) throws IOException {
        this(local, remote, new OSCSerializerAndParserBuilder());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public UDPTransport(SocketAddress local, SocketAddress remote, OSCSerializerAndParserBuilder serializerAndParserBuilder) throws IOException {
        DatagramChannel tmpChannel;
        this.local = local;
        this.remote = remote;
        if (local instanceof InetSocketAddress && LibraryInfo.hasStandardProtocolFamily()) {
            Class<?> remoteClass;
            InetSocketAddress localIsa = (InetSocketAddress)local;
            InetSocketAddress remoteIsa = (InetSocketAddress)remote;
            Class<?> localClass = localIsa.getAddress().getClass();
            if (!localClass.equals(remoteClass = remoteIsa.getAddress().getClass())) {
                throw new IllegalArgumentException("local and remote addresses are not of the same family (IP v4 vs v6)");
            }
            if (localIsa.getAddress() instanceof Inet4Address) {
                tmpChannel = DatagramChannel.open(StandardProtocolFamily.INET);
            } else {
                if (!(localIsa.getAddress() instanceof Inet6Address)) throw new IllegalArgumentException("Unknown address type: " + localIsa.getAddress().getClass().getCanonicalName());
                tmpChannel = DatagramChannel.open(StandardProtocolFamily.INET6);
            }
        } else {
            tmpChannel = DatagramChannel.open();
        }
        this.channel = tmpChannel;
        if (LibraryInfo.hasStandardProtocolFamily()) {
            this.channel.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)65507);
            this.channel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
            this.channel.setOption((SocketOption)StandardSocketOptions.SO_BROADCAST, (Object)true);
        } else {
            this.channel.socket().setSendBufferSize(65507);
            this.channel.socket().setReuseAddress(true);
            this.channel.socket().setBroadcast(true);
        }
        this.channel.socket().bind(local);
        this.oscChannel = new OSCDatagramChannel(this.channel, serializerAndParserBuilder);
    }

    @Override
    public void connect() throws IOException {
        if (this.remote == null) {
            throw new IllegalStateException("Can not connect a socket without a remote address specified");
        }
        this.channel.connect(this.remote);
    }

    @Override
    public void disconnect() throws IOException {
        this.channel.disconnect();
    }

    @Override
    public boolean isConnected() {
        return this.channel.isConnected();
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    @Override
    public void send(OSCPacket packet) throws IOException, OSCSerializeException {
        this.oscChannel.send(this.buffer, packet, this.remote);
    }

    @Override
    public OSCPacket receive() throws IOException, OSCParseException {
        return this.oscChannel.read(this.buffer);
    }

    @Override
    public boolean isBlocking() {
        return this.channel.isBlocking();
    }

    public String toString() {
        return String.format("%s: local=%s, remote=%s", this.getClass().getSimpleName(), this.local, this.remote);
    }
}

