/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.configuration;

import de.mossgrabers.framework.configuration.IStringSetting;
import de.mossgrabers.reaper.framework.configuration.BaseValueSetting;
import de.mossgrabers.reaper.ui.utils.LogModel;
import de.mossgrabers.reaper.ui.utils.PropertiesEx;
import de.mossgrabers.reaper.ui.utils.SafeRunLater;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;

public class StringSettingImpl
extends BaseValueSetting<JTextField, String>
implements IStringSetting {
    private final String initialValue;
    private String value;

    public StringSettingImpl(LogModel logModel, PropertiesEx properties, String label, String category, String initialValue) {
        super(logModel, label, category, new JTextField(initialValue));
        this.initialValue = initialValue;
        this.load(properties);
        ((JTextField)this.field).addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                SafeRunLater.execute(StringSettingImpl.this.logModel, () -> StringSettingImpl.this.set(((JTextField)StringSettingImpl.this.field).getText()));
            }
        });
    }

    @Override
    public void set(String value) {
        this.value = value;
        this.setDirty();
        this.flush();
        SafeRunLater.execute(this.logModel, () -> {
            String v = ((JTextField)this.field).getText();
            if (v == null || !v.equals(this.value)) {
                ((JTextField)this.field).setText(this.value);
            }
        });
    }

    @Override
    public String get() {
        return this.value;
    }

    @Override
    public void flush() {
        this.notifyObservers(this.value == null ? "" : this.value);
    }

    @Override
    public void store(PropertiesEx properties) {
        properties.put(this.getID(), this.value);
    }

    @Override
    public void load(PropertiesEx properties) {
        this.set(properties.getString(this.getID(), this.initialValue));
    }

    @Override
    public void reset() {
        this.set(this.initialValue);
    }
}

