/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.graphics.canvas.component;

import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.resource.ResourceHandler;
import de.mossgrabers.framework.graphics.Align;
import de.mossgrabers.framework.graphics.IBounds;
import de.mossgrabers.framework.graphics.IGraphicsConfiguration;
import de.mossgrabers.framework.graphics.IGraphicsContext;
import de.mossgrabers.framework.graphics.IGraphicsDimensions;
import de.mossgrabers.framework.graphics.IGraphicsInfo;
import de.mossgrabers.framework.graphics.IImage;
import de.mossgrabers.framework.graphics.canvas.component.IComponent;

public class LabelComponent
implements IComponent {
    private final String text;
    private final String icon;
    private final boolean isSelected;
    private final boolean isActive;
    private final LabelLayout layout;
    private ColorEx backgroundColor;

    public LabelComponent(String text, String icon, ColorEx color, boolean isSelected, boolean isActive, LabelLayout layout) {
        this.text = text;
        this.icon = icon;
        this.backgroundColor = color;
        this.isSelected = isSelected;
        this.isActive = isActive;
        this.layout = layout;
    }

    @Override
    public void draw(IGraphicsInfo info) {
        if (this.layout == LabelLayout.COLORED) {
            this.drawColoredLayout(info);
            return;
        }
        IGraphicsConfiguration configuration = info.getConfiguration();
        IBounds bounds = info.getBounds();
        IGraphicsDimensions dimensions = info.getDimensions();
        double separatorSize = dimensions.getSeparatorSize();
        double menuHeight = dimensions.getMenuHeight();
        ColorEx bgColor = this.getBackgroundColor(configuration);
        ColorEx textColor = ColorEx.calcContrastColor(bgColor);
        IGraphicsContext gc = info.getContext();
        if (this.text == null || this.text.length() == 0) {
            if (this.layout == LabelLayout.SMALL_HEADER) {
                gc.fillRectangle(bounds.left() - separatorSize, menuHeight - 2.0, separatorSize, 1.0, configuration.getColorBorder());
            }
            return;
        }
        double left = bounds.left();
        double top = bounds.top();
        double width = bounds.width();
        double height = bounds.height();
        if (this.layout == LabelLayout.SMALL_HEADER) {
            gc.fillRectangle(left, top, width, menuHeight - 1.0, this.isSelected ? textColor : bgColor);
            gc.fillRectangle(left, menuHeight - 2.0, width + separatorSize, 1.0, textColor);
        } else {
            gc.fillRectangle(left, top, width, height, this.isSelected ? textColor : bgColor);
        }
        double unit = dimensions.getUnit();
        if (this.layout == LabelLayout.SMALL_HEADER) {
            gc.drawTextInBounds(this.text, left, 1.0, width, unit + separatorSize, Align.CENTER, this.isSelected ? bgColor : textColor, unit);
        } else {
            gc.drawTextInBounds(this.text, left, top, width, height, Align.CENTER, this.isSelected ? bgColor : textColor, height / 2.0);
        }
    }

    protected void drawColoredLayout(IGraphicsInfo info) {
        IGraphicsContext gc = info.getContext();
        IGraphicsDimensions dimensions = info.getDimensions();
        IGraphicsConfiguration configuration = info.getConfiguration();
        IBounds bounds = info.getBounds();
        double left = bounds.left();
        double width = bounds.width();
        double top = bounds.top();
        double height = bounds.height();
        double inset = dimensions.getInset();
        double unit = dimensions.getUnit();
        String iconName = this.getIcon();
        double textHeight = 1.2 * unit + 1.0;
        double textTop = top + height - textHeight;
        ColorEx infoColor = this.backgroundColor;
        gc.fillRectangle(left, textTop, width, textHeight, this.isActive ? infoColor : ColorEx.evenDarker(infoColor));
        double offsetX = 0.0;
        if (iconName != null) {
            double leftColumn = left + inset - 1.0;
            IImage image = ResourceHandler.getSVGImage(iconName);
            offsetX = image.getWidth() + 1.4 * inset;
            double y = textTop + (textHeight - (double)image.getHeight()) / 2.0;
            ColorEx maskColor = this.getMaskColor(configuration);
            if (maskColor == null) {
                gc.drawImage(image, leftColumn, y);
            } else {
                if (this.isSelected) {
                    maskColor = ColorEx.calcContrastColor(maskColor);
                }
                gc.maskImage(image, leftColumn, y, this.modifyIfOff(maskColor));
            }
        }
        ColorEx colorText = configuration.getColorText();
        if (this.isSelected) {
            colorText = ColorEx.calcContrastColor(colorText);
        }
        gc.drawTextInBounds(this.text, left + offsetX, textTop, width - offsetX - 1.4 * inset, textHeight, Align.LEFT, this.modifyIfOff(colorText), unit);
    }

    public String getIcon() {
        return this.icon;
    }

    public String getText() {
        return this.text;
    }

    public void setColor(ColorEx backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    private ColorEx modifyIfOff(ColorEx color) {
        return this.isActive ? color : ColorEx.dimToGray(color);
    }

    protected ColorEx getMaskColor(IGraphicsConfiguration configuration) {
        return configuration.getColorText();
    }

    private ColorEx getBackgroundColor(IGraphicsConfiguration configuration) {
        if (this.isSelected) {
            return configuration.getColorText();
        }
        if (this.backgroundColor != null) {
            return this.backgroundColor;
        }
        if (this.layout == LabelLayout.COLORED) {
            return configuration.getColorBackground();
        }
        if (this.layout == LabelLayout.PLAIN) {
            return configuration.getColorBackgroundDarker();
        }
        return configuration.getColorBorder();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.backgroundColor == null ? 0 : this.backgroundColor.hashCode());
        result = 31 * result + (this.icon == null ? 0 : this.icon.hashCode());
        result = 31 * result + (this.isActive ? 1231 : 1237);
        result = 31 * result + (this.isSelected ? 1231 : 1237);
        result = 31 * result + (this.layout == null ? 0 : this.layout.hashCode());
        return 31 * result + (this.text == null ? 0 : this.text.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LabelComponent other = (LabelComponent)obj;
        if (this.backgroundColor == null ? other.backgroundColor != null : !this.backgroundColor.equals(other.backgroundColor)) {
            return false;
        }
        if (this.icon == null ? other.icon != null : !this.icon.equals(other.icon)) {
            return false;
        }
        if (this.isActive != other.isActive || this.isSelected != other.isSelected || this.layout != other.layout) {
            return false;
        }
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }

    public static enum LabelLayout {
        PLAIN,
        SMALL_HEADER,
        COLORED;

    }
}

