/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.oxi.one.view;

import de.mossgrabers.controller.oxi.one.OxiOneConfiguration;
import de.mossgrabers.controller.oxi.one.controller.OxiOneControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.daw.constants.Resolution;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.sequencer.AbstractNoteSequencerView;

public class OxiOneSequencerView
extends AbstractNoteSequencerView<OxiOneControlSurface, OxiOneConfiguration> {
    public OxiOneSequencerView(OxiOneControlSurface surface, IModel model) {
        super("Sequencer", surface, model, 16, 8, true);
        this.numDisplayRows = 8;
    }

    @Override
    public void onGridNote(int note, int velocity) {
        boolean init = ((OxiOneControlSurface)this.surface).isPressed(ButtonID.PUNCH_IN);
        boolean end = ((OxiOneControlSurface)this.surface).isPressed(ButtonID.PUNCH_OUT);
        if (init || end) {
            if (velocity == 0) {
                INoteClip clip = this.getClip();
                int lengthOfOnePage = this.getLengthOfOnePage(this.numDisplayCols);
                int offset = clip.getEditPage() * lengthOfOnePage;
                int index = note - ((OxiOneControlSurface)this.surface).getPadGrid().getStartNote();
                int x = index % this.numDisplayCols;
                double lengthOfOnePad = Resolution.getValueAt(this.getResolutionIndex());
                double pos = (double)offset + (double)x * lengthOfOnePad;
                double newStart = init ? pos : clip.getLoopStart();
                double newLength = end ? Math.max(pos - newStart + lengthOfOnePad, lengthOfOnePad) : clip.getLoopLength();
                clip.setLoopStart(newStart);
                clip.setLoopLength(newLength);
                clip.setPlayRange(newStart, newStart + newLength);
            }
            return;
        }
        super.onGridNote(note, velocity);
    }

    @Override
    public void onGridNoteLongPress(int note) {
        if (!this.isActive()) {
            return;
        }
        int index = note - ((OxiOneControlSurface)this.surface).getPadGrid().getStartNote();
        ((OxiOneControlSurface)this.surface).getButton(ButtonID.get(ButtonID.PAD1, index)).setConsumed();
        int y = index / this.numDisplayCols;
        int x = index % this.numDisplayCols;
        int mappedY = this.keyManager.map(y);
        NotePosition notePosition = new NotePosition(this.configuration.getMidiEditChannel(), x, mappedY);
        this.editNote(this.getClip(), notePosition, false);
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        if (ButtonID.isSceneButton(buttonID)) {
            this.onSceneButton(buttonID, event);
        }
    }

    @Override
    protected boolean handleSequencerAreaButtonCombinations(INoteClip clip, NotePosition notePosition, int row, int velocity) {
        if (((OxiOneControlSurface)this.surface).isPressed(ButtonID.REPEAT) || ((OxiOneControlSurface)this.surface).isPressed(ButtonID.ACCENT)) {
            if (velocity > 0) {
                this.handleSequencerAreaRepeatOperator(clip, notePosition, velocity, ((OxiOneControlSurface)this.surface).isPressed(ButtonID.REPEAT));
            }
            return true;
        }
        return super.handleSequencerAreaButtonCombinations(clip, notePosition, row, velocity);
    }
}

