/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchcontrol.mode.main;

import de.mossgrabers.controller.novation.launchcontrol.controller.LaunchControlXLControlSurface;
import de.mossgrabers.controller.novation.launchcontrol.mode.main.XLAbstractTrackMode;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameterprovider.IParameterProvider;
import de.mossgrabers.framework.parameterprovider.device.BankParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.CombinedParameterProvider;
import de.mossgrabers.framework.parameterprovider.track.PanParameterProvider;
import de.mossgrabers.framework.parameterprovider.track.SendParameterProvider;
import java.util.List;

public class XLTrackMixMode
extends XLAbstractTrackMode {
    private static final String[] MODE_NAMES = new String[]{"Cursor Device Parameters", "Track Parameters", "Project Parameters"};
    private int selectedDeviceParamProviderIndex = 0;
    private final IParameterProvider[] deviceParamProviders = new IParameterProvider[3];
    private final IParameterProvider sendParameterProvider1;
    private final IParameterProvider sendParameterProvider2;
    private final CombinedParameterProvider firstParameterProvider;

    public XLTrackMixMode(LaunchControlXLControlSurface surface, IModel model, List<ContinuousID> controls) {
        super("Send A, B & Panning", surface, model, controls);
        this.sendParameterProvider1 = new SendParameterProvider(model, 0, 0);
        this.sendParameterProvider2 = new SendParameterProvider(model, 1, 0);
        PanParameterProvider panParameterProvider = new PanParameterProvider(model);
        this.deviceParamProviders[0] = new BankParameterProvider(model.getCursorDevice().getParameterBank());
        this.deviceParamProviders[1] = new BankParameterProvider(model.getCursorTrack().getParameterBank());
        this.deviceParamProviders[2] = new BankParameterProvider(model.getProject().getParameterBank());
        this.firstParameterProvider = new CombinedParameterProvider(this.sendParameterProvider1, this.sendParameterProvider2, panParameterProvider);
        this.updateDeviceParametersProvider();
    }

    @Override
    public int getKnobValue(int index) {
        int row = index / 8;
        int column = index % 8;
        ITrack track = (ITrack)this.model.getTrackBank().getItem(column);
        switch (row) {
            case 0: {
                return ((ISend)track.getSendBank().getItem(0)).getValue();
            }
            case 1: {
                return ((ISend)track.getSendBank().getItem(1)).getValue();
            }
            case 2: {
                if (this.configuration.isDeviceActive()) {
                    return ((IParameter)this.getParamBank().getItem(column)).getValue();
                }
                return track.getPan();
            }
        }
        return 0;
    }

    @Override
    public void setKnobColor(int row, int column, int value) {
        int green = 0;
        int red = 0;
        switch (row) {
            case 0: {
                green = value == 0 ? 0 : value / 42 + 1;
                break;
            }
            case 1: {
                red = value == 0 ? 0 : value / 42 + 1;
                break;
            }
            case 2: {
                int n = green = value == 0 ? 0 : value / 42 + 1;
                if (this.configuration.isDeviceActive()) {
                    red = green == 0 ? 0 : 1;
                    break;
                }
                red = green;
                break;
            }
            default: {
                return;
            }
        }
        ((LaunchControlXLControlSurface)this.surface).setKnobLEDColor(row, column, green, red);
    }

    private void updateDeviceParametersProvider() {
        CombinedParameterProvider secondParameterProvider = new CombinedParameterProvider(this.sendParameterProvider1, this.sendParameterProvider2, this.deviceParamProviders[this.selectedDeviceParamProviderIndex]);
        this.setParameterProviders(this.firstParameterProvider, secondParameterProvider);
    }

    private IParameterBank getParamBank() {
        if (this.selectedDeviceParamProviderIndex == 0) {
            return this.model.getCursorDevice().getParameterBank();
        }
        if (this.selectedDeviceParamProviderIndex == 1) {
            return this.model.getCursorTrack().getParameterBank();
        }
        return this.model.getProject().getParameterBank();
    }

    public void selectParameterMode(boolean increase) {
        this.selectedDeviceParamProviderIndex = Math.clamp((long)(this.selectedDeviceParamProviderIndex + (increase ? 1 : -1)), 0, 2);
        this.updateDeviceParametersProvider();
        this.bindControls();
        this.model.getHost().showNotification(MODE_NAMES[this.selectedDeviceParamProviderIndex]);
    }
}

