/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.arturia.beatstep.view;

import de.mossgrabers.controller.arturia.beatstep.BeatstepConfiguration;
import de.mossgrabers.controller.arturia.beatstep.controller.BeatstepControlSurface;
import de.mossgrabers.controller.arturia.beatstep.view.BeatstepView;
import de.mossgrabers.controller.arturia.beatstep.view.TrackEditing;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.constants.Resolution;
import de.mossgrabers.framework.view.sequencer.AbstractSequencerView;

public abstract class BaseSequencerView
extends AbstractSequencerView<BeatstepControlSurface, BeatstepConfiguration>
implements BeatstepView {
    protected TrackEditing extensions;
    protected int selectedPad;
    protected boolean isPlayMode = true;

    protected BaseSequencerView(String name, BeatstepControlSurface surface, IModel model, int rows, int cols) {
        super(name, surface, model, rows, cols, false);
        this.extensions = new TrackEditing(surface, model);
    }

    protected void changeScrollPosition(boolean isTurnedRight) {
        if (!this.isActive()) {
            return;
        }
        if (isTurnedRight) {
            this.getClip().scrollStepsPageForward();
        } else {
            this.getClip().scrollStepsPageBackwards();
        }
    }

    protected void changeResolution(int value) {
        if (!this.isActive()) {
            return;
        }
        boolean isInc = value >= 65;
        int selectedResolutionIndex = Resolution.change(this.getResolutionIndex(), isInc);
        this.getClip().setStepLength(Resolution.getValueAt(selectedResolutionIndex));
    }
}

