/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.controller;

import de.mossgrabers.controller.ableton.push.controller.ColorPaletteEntry;
import de.mossgrabers.controller.ableton.push.controller.PushColorManager;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;

public class ColorPalette {
    private final PushControlSurface surface;
    private final ColorPaletteEntry[] entries = new ColorPaletteEntry[128];
    private final Object updateLock = new Object();
    private boolean entriesHasUpdate = false;

    public ColorPalette(PushControlSurface surface) {
        this.surface = surface;
        for (int i = 0; i < this.entries.length; ++i) {
            this.entries[i] = new ColorPaletteEntry(i, PushColorManager.getPaletteColorRGB(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePalette() {
        Object object = this.updateLock;
        synchronized (object) {
            int entryIndex = this.findNextEntry();
            if (entryIndex < 0) {
                if (this.entriesHasUpdate) {
                    this.surface.scheduleTask(() -> this.surface.sendSysex("05"), 1000L);
                }
                return;
            }
            switch (this.entries[entryIndex].getState()) {
                case READ: {
                    this.sendColorEntryRequest(entryIndex);
                    break;
                }
                case READ_REQUESTED: {
                    if (System.currentTimeMillis() - this.entries[entryIndex].getSendTimestamp() <= 1000L) break;
                    this.sendColorEntryRequest(entryIndex);
                    break;
                }
                case WRITE: {
                    if (this.entries[entryIndex].incWriteRetries()) {
                        this.surface.sendSysex(this.entries[entryIndex].createUpdateMessage());
                        break;
                    }
                    this.surface.errorln("Failed writing color palette entry #" + entryIndex + ".");
                    break;
                }
                default: {
                    return;
                }
            }
        }
        this.surface.scheduleTask(this::updatePalette, 10L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleColorPaletteMessage(int[] data) {
        if (!ColorPaletteEntry.isValid(data)) {
            return;
        }
        Object object = this.updateLock;
        synchronized (object) {
            int index = data[7];
            if (!this.entries[index].requiresUpdate(data)) {
                this.entries[index].setDone();
                return;
            }
            this.entriesHasUpdate = true;
            this.entries[index].setWrite();
        }
    }

    private int findNextEntry() {
        for (int i = 0; i < this.entries.length; ++i) {
            if (this.entries[i].getState() == ColorPaletteEntry.State.DONE) continue;
            return i;
        }
        return -1;
    }

    private void sendColorEntryRequest(int entryIndex) {
        if (!this.entries[entryIndex].incReadRetries()) {
            this.surface.errorln("Failed reading color palette entry #" + entryIndex + ".");
            return;
        }
        this.surface.sendSysex(new int[]{4, entryIndex});
    }
}

