/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc.argument.handler;

import com.illposed.osc.BytesReceiver;
import com.illposed.osc.argument.ArgumentHandler;
import java.nio.ByteBuffer;
import java.util.Map;

public class IntegerArgumentHandler
implements ArgumentHandler<Integer>,
Cloneable {
    public static final int BYTES = 4;
    public static final ArgumentHandler<Integer> INSTANCE = new IntegerArgumentHandler();

    protected IntegerArgumentHandler() {
    }

    @Override
    public char getDefaultIdentifier() {
        return 'i';
    }

    @Override
    public Class<Integer> getJavaClass() {
        return Integer.class;
    }

    @Override
    public void setProperties(Map<String, Object> properties) {
    }

    @Override
    public boolean isMarkerOnly() {
        return false;
    }

    public IntegerArgumentHandler clone() throws CloneNotSupportedException {
        return (IntegerArgumentHandler)super.clone();
    }

    @Override
    public Integer parse(ByteBuffer input) {
        Integer value = input.asIntBuffer().get();
        input.position(input.position() + 4);
        return value;
    }

    @Override
    public void serialize(BytesReceiver output, Integer value) {
        int curValue = value;
        byte[] intBytes = new byte[4];
        intBytes[3] = (byte)curValue;
        intBytes[2] = (byte)(curValue >>>= 8);
        intBytes[1] = (byte)(curValue >>>= 8);
        intBytes[0] = (byte)(curValue >>>= 8);
        output.put(intBytes);
    }
}

