/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.device.column;

import de.mossgrabers.reaper.framework.device.DeviceCollection;
import de.mossgrabers.reaper.framework.device.DeviceManager;
import de.mossgrabers.reaper.framework.device.column.BaseColumn;
import de.mossgrabers.reaper.framework.device.column.BaseColumnItem;
import java.util.ArrayList;
import java.util.List;

public class DeviceCollectionFilterColumn
extends BaseColumn {
    public DeviceCollectionFilterColumn(int columnIndex, int numFilterColumnEntries) {
        super(columnIndex, "Collection", numFilterColumnEntries);
        for (int i = 0; i < numFilterColumnEntries; ++i) {
            this.items[i] = new DeviceFolderBrowserColumnItem(i);
        }
    }

    @Override
    protected int getMaxNumItems() {
        return DeviceManager.get().getCollections().size();
    }

    @Override
    public List<String> getAllItems() {
        List<DeviceCollection> collections = DeviceManager.get().getCollections();
        ArrayList<String> result = new ArrayList<String>(collections.size());
        for (DeviceCollection collection : collections) {
            result.add(collection.getName());
        }
        return result;
    }

    private class DeviceFolderBrowserColumnItem
    extends BaseColumnItem {
        public DeviceFolderBrowserColumnItem(int index) {
            super(index);
        }

        @Override
        public int getIndex() {
            return DeviceCollectionFilterColumn.this.calcPosition(this.index);
        }

        @Override
        public boolean isSelected() {
            return this.getIndex() == DeviceCollectionFilterColumn.this.selectedRow;
        }

        @Override
        protected String getCachedName() {
            if (this.position == 0) {
                return "All";
            }
            int pos = this.position - 1;
            return pos < DeviceCollectionFilterColumn.this.getMaxNumItems() ? DeviceManager.get().getCollections().get(pos).getName() : "";
        }

        @Override
        protected int getCachedHitCount() {
            DeviceManager deviceManager = DeviceManager.get();
            if (this.position == 0) {
                return deviceManager.getNumDevices();
            }
            int pos = this.position - 1;
            return pos < DeviceCollectionFilterColumn.this.getMaxNumItems() ? deviceManager.filterByCollection(deviceManager.getCollections().get(pos)).size() : 0;
        }
    }
}

