/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.mode.device;

import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.featuregroup.AbstractParameterMode;
import de.mossgrabers.framework.parameter.IParameter;
import java.util.List;
import java.util.function.BooleanSupplier;

public class SelectedDeviceMode<S extends IControlSurface<C>, C extends Configuration>
extends AbstractParameterMode<S, C, IParameter> {
    private int selParam = 0;

    public SelectedDeviceMode(S surface, IModel model, List<ContinuousID> knobs) {
        super("Parameters", surface, model, false, model.getCursorDevice().getParameterBank(), knobs);
    }

    public SelectedDeviceMode(S surface, IModel model, List<ContinuousID> knobs, BooleanSupplier isAlternativeFunction) {
        super("Parameters", surface, model, false, model.getCursorDevice().getParameterBank(), knobs, isAlternativeFunction);
    }

    @Override
    public void onKnobValue(int index, int value) {
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        if (cursorDevice == null) {
            return;
        }
        IParameter item = (IParameter)cursorDevice.getParameterBank().getItem(index < 0 ? this.selParam : index);
        if (item.doesExist()) {
            item.changeValue(value);
        }
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        if (cursorDevice == null) {
            return;
        }
        IParameter item = (IParameter)cursorDevice.getParameterBank().getItem(index < 0 ? this.selParam : index);
        if (!item.doesExist()) {
            return;
        }
        if (isTouched && this.surface.isDeletePressed()) {
            this.surface.setTriggerConsumed(ButtonID.DELETE);
            item.resetValue();
        }
        item.touchValue(isTouched);
    }

    public void selectParameter(int index) {
        this.selParam = index;
    }

    public int getSelectedParameter() {
        return this.selParam == -1 ? 0 : this.selParam;
    }
}

