/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.osc.protocol;

import de.mossgrabers.controller.osc.OSCControlSurface;
import de.mossgrabers.controller.osc.exception.IllegalParameterException;
import de.mossgrabers.controller.osc.exception.MissingCommandException;
import de.mossgrabers.controller.osc.exception.UnknownCommandException;
import de.mossgrabers.controller.osc.module.IModule;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.osc.AbstractOpenSoundControlParser;
import de.mossgrabers.framework.osc.IOpenSoundControlConfiguration;
import de.mossgrabers.framework.osc.IOpenSoundControlMessage;
import de.mossgrabers.framework.osc.IOpenSoundControlWriter;
import de.mossgrabers.framework.utils.KeyManager;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class OSCParser
extends AbstractOpenSoundControlParser {
    private final OSCControlSurface surface;
    private final Map<String, IModule> modules = new HashMap<String, IModule>();

    public OSCParser(IHost host, OSCControlSurface surface, IModel model, IOpenSoundControlConfiguration configuration, IOpenSoundControlWriter writer, IMidiInput midiInput, KeyManager keyManager) {
        super(host, model, midiInput, configuration, writer);
        this.surface = surface;
        this.model.getCurrentTrackBank().setIndication(true);
        this.surface.setKeyTranslationTable(model.getScales().getNoteMatrix());
    }

    @Override
    public void handle(IOpenSoundControlMessage message) {
        this.logMessage(message);
        LinkedList<String> oscParts = OSCParser.parseAddress(message);
        if (oscParts.isEmpty()) {
            return;
        }
        String command = oscParts.removeFirst();
        if ("refresh".equals(command)) {
            this.writer.flush(true);
            return;
        }
        Object[] values = message.getValues();
        try {
            IModule module = this.modules.get(command);
            if (module == null) {
                throw new UnknownCommandException(command);
            }
            if (values != null && values.length > 1) {
                module.execute(command, oscParts, values);
            } else {
                module.execute(command, oscParts, values == null || values.length == 0 ? null : values[0]);
            }
        }
        catch (IllegalParameterException ex) {
            this.host.println("Illegal parameter: " + message.getAddress() + " " + ex.getMessage());
        }
        catch (UnknownCommandException ex) {
            this.host.println("Unknown OSC command: " + message.getAddress() + " " + ex.getMessage());
        }
        catch (MissingCommandException ex) {
            this.host.println("Missing command: " + message.getAddress());
        }
    }

    private static LinkedList<String> parseAddress(IOpenSoundControlMessage message) {
        LinkedList<String> oscParts = new LinkedList<String>();
        Collections.addAll(oscParts, message.getAddress().split("/"));
        oscParts.removeFirst();
        return oscParts;
    }

    public void registerModule(IModule module) {
        Arrays.asList(module.getSupportedCommands()).forEach(command -> this.modules.put((String)command, module));
    }
}

