/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchcontrol.mode.buttons;

import de.mossgrabers.controller.novation.launchcontrol.LaunchControlXLConfiguration;
import de.mossgrabers.controller.novation.launchcontrol.controller.LaunchControlXLControlSurface;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.IStepInfo;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.daw.clip.StepState;
import de.mossgrabers.framework.mode.sequencer.AbstractSequencerMode;
import de.mossgrabers.framework.utils.ButtonEvent;

public class XLNoteSequencerMode
extends AbstractSequencerMode<LaunchControlXLControlSurface, LaunchControlXLConfiguration> {
    protected int numColumns;
    protected final Configuration configuration;

    public XLNoteSequencerMode(LaunchControlXLControlSurface surface, IModel model) {
        super("Note Sequencer", surface, model, true, 127, 8, false);
        this.configuration = ((LaunchControlXLControlSurface)this.surface).getConfiguration();
        this.numColumns = this.clipCols;
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        int index = buttonID.ordinal() - ButtonID.ROW2_1.ordinal();
        if (index < 0 || index >= 8) {
            return 12;
        }
        INoteClip clip = this.getClip();
        return this.getSequencerStepColor(clip, index);
    }

    @Override
    public void onButton(int row, int index, ButtonEvent event) {
        int highestRow;
        int channel;
        NotePosition notePosition;
        if (event != ButtonEvent.UP) {
            return;
        }
        INoteClip clip = this.getClip();
        IStepInfo step = clip.getStep(notePosition = new NotePosition(channel = this.configuration.getMidiEditChannel(), index, highestRow = clip.getHighestRow(channel, index)));
        if (step.getState() == StepState.START) {
            clip.updateStepMuteState(notePosition, !step.isMuted());
        }
    }

    protected int getSequencerStepColor(INoteClip clip, int column) {
        int highestRow;
        int step = clip.getCurrentStep();
        int hiStep = this.isInXRange(step) ? step % this.numColumns : -1;
        boolean hilite = column == hiStep;
        int channel = this.configuration.getMidiEditChannel();
        NotePosition notePosition = new NotePosition(channel, column, highestRow = clip.getHighestRow(channel, column));
        IStepInfo stepInfo = clip.getStep(notePosition);
        String colorID = stepInfo.getState() == StepState.START && stepInfo.isMuted() ? (hilite ? "COLOR_STEP_HILITE_CONTENT" : "COLOR_STEP_MUTED") : (hilite ? "COLOR_STEP_HILITE_NO_CONTENT" : "COLOR_NO_CONTENT");
        return this.colorManager.getColorIndex(colorID);
    }

    protected boolean isInXRange(int x) {
        INoteClip clip = this.getClip();
        int stepSize = clip.getNumSteps();
        int start = clip.getEditPage() * stepSize;
        return x >= start && x < start + stepSize;
    }
}

