/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.generic.flexihandler;

import de.mossgrabers.controller.generic.GenericFlexiConfiguration;
import de.mossgrabers.controller.generic.controller.FlexiCommand;
import de.mossgrabers.controller.generic.controller.GenericFlexiControlSurface;
import de.mossgrabers.controller.generic.flexihandler.AbstractHandler;
import de.mossgrabers.controller.generic.flexihandler.utils.FlexiHandlerException;
import de.mossgrabers.controller.generic.flexihandler.utils.KnobMode;
import de.mossgrabers.controller.generic.flexihandler.utils.MidiValue;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.GrooveParameterID;
import de.mossgrabers.framework.daw.IGroove;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.parameter.IParameter;

public class GrooveHandler
extends AbstractHandler {
    private final IGroove groove;

    public GrooveHandler(IModel model, GenericFlexiControlSurface surface, GenericFlexiConfiguration configuration, IValueChanger absoluteLowResValueChanger, IValueChanger signedBitRelativeValueChanger, IValueChanger signedBit2RelativeValueChanger, IValueChanger offsetBinaryRelativeValueChanger) {
        super(model, surface, configuration, absoluteLowResValueChanger, signedBitRelativeValueChanger, signedBit2RelativeValueChanger, offsetBinaryRelativeValueChanger);
        this.groove = this.model.getGroove();
    }

    @Override
    public FlexiCommand[] getSupportedCommands() {
        return new FlexiCommand[]{FlexiCommand.GROOVE_ACTIVE, FlexiCommand.GROOVE_SHUFFLE_AMOUNT, FlexiCommand.GROOVE_ACCENT_AMOUNT};
    }

    @Override
    public int getCommandValue(FlexiCommand command) {
        switch (command) {
            case GROOVE_ACTIVE: {
                return GrooveHandler.toMidiValue(this.groove.getParameter(GrooveParameterID.ENABLED).getValue() > 0);
            }
            case GROOVE_SHUFFLE_AMOUNT: {
                return this.groove.getParameter(GrooveParameterID.SHUFFLE_AMOUNT).getValue();
            }
            case GROOVE_ACCENT_AMOUNT: {
                return this.groove.getParameter(GrooveParameterID.ACCENT_AMOUNT).getValue();
            }
        }
        return -1;
    }

    @Override
    public void handle(FlexiCommand command, KnobMode knobMode, MidiValue value) {
        boolean isButtonPressed = this.isButtonPressed(knobMode, value);
        switch (command) {
            case GROOVE_ACTIVE: {
                IParameter parameter;
                if (!isButtonPressed) break;
                parameter.setValue((parameter = this.groove.getParameter(GrooveParameterID.ENABLED)).getValue() == 0 ? this.model.getValueChanger().getUpperBound() - 1 : 0);
                break;
            }
            case GROOVE_SHUFFLE_AMOUNT: {
                this.changeValue(this.groove.getParameter(GrooveParameterID.SHUFFLE_AMOUNT), knobMode, value);
                break;
            }
            case GROOVE_ACCENT_AMOUNT: {
                this.changeValue(this.groove.getParameter(GrooveParameterID.ACCENT_AMOUNT), knobMode, value);
                break;
            }
            default: {
                throw new FlexiHandlerException(command);
            }
        }
    }

    private void changeValue(IParameter parameter, KnobMode knobMode, MidiValue value) {
        int val = value.getValue();
        if (GrooveHandler.isAbsolute(knobMode)) {
            parameter.setValue(this.getAbsoluteValueChanger(value), val);
        } else {
            parameter.changeValue(this.getRelativeValueChanger(knobMode), val);
        }
    }
}

