/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.featuregroup;

import de.mossgrabers.framework.MVHelper;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.featuregroup.IFeatureGroup;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.view.Views;

public abstract class AbstractFeatureGroup<S extends IControlSurface<C>, C extends Configuration>
implements IFeatureGroup {
    public static final String BUTTON_COLOR_OFF = "BUTTON_COLOR_OFF";
    public static final String BUTTON_COLOR_ON = "BUTTON_COLOR_ON";
    protected final String name;
    protected final S surface;
    protected final IModel model;
    protected final ColorManager colorManager;
    protected final MVHelper<S, C> mvHelper;

    protected AbstractFeatureGroup(String name, S surface, IModel model) {
        this.name = name;
        this.surface = surface;
        this.model = model;
        this.colorManager = this.model.getColorManager();
        this.mvHelper = new MVHelper(model, surface);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        return this.colorManager.getColorIndex(this.getButtonColorID(buttonID));
    }

    protected String getButtonColorID(ButtonID buttonID) {
        return BUTTON_COLOR_OFF;
    }

    protected void activatePreferredView(Views viewID) {
        if (viewID == null) {
            return;
        }
        ViewManager viewManager = this.surface.getViewManager();
        if (viewManager.get(viewID) == null) {
            return;
        }
        viewManager.setActive(viewID);
        ICursorTrack cursorTrack = this.model.getCursorTrack();
        if (cursorTrack.doesExist()) {
            viewManager.setPreferredView(cursorTrack.getPosition(), viewID);
        }
    }

    protected boolean isButtonCombination(ButtonID buttonID) {
        if (this.surface.isPressed(buttonID)) {
            this.surface.setTriggerConsumed(buttonID);
            return true;
        }
        return false;
    }
}

