/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.generic.flexihandler;

import de.mossgrabers.controller.generic.GenericFlexiConfiguration;
import de.mossgrabers.controller.generic.controller.GenericFlexiControlSurface;
import de.mossgrabers.controller.generic.flexihandler.IFlexiCommandHandler;
import de.mossgrabers.controller.generic.flexihandler.utils.KnobMode;
import de.mossgrabers.controller.generic.flexihandler.utils.MidiValue;
import de.mossgrabers.framework.MVHelper;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IModel;

public abstract class AbstractHandler
implements IFlexiCommandHandler {
    protected static final int SCROLL_RATE = 6;
    protected final IValueChanger absoluteLowResValueChanger;
    protected final IValueChanger signedBitRelativeValueChanger;
    protected final IValueChanger signedBit2RelativeValueChanger;
    protected final IValueChanger offsetBinaryRelativeValueChanger;
    protected final IModel model;
    protected final MVHelper<GenericFlexiControlSurface, GenericFlexiConfiguration> mvHelper;
    protected final GenericFlexiControlSurface surface;
    protected final GenericFlexiConfiguration configuration;
    private int movementCounter = 0;

    protected AbstractHandler(IModel model, GenericFlexiControlSurface surface, GenericFlexiConfiguration configuration, IValueChanger absoluteLowResValueChanger, IValueChanger signedBitRelativeValueChanger, IValueChanger signedBit2RelativeValueChanger, IValueChanger offsetBinaryRelativeValueChanger) {
        this.model = model;
        this.surface = surface;
        this.configuration = configuration;
        this.mvHelper = new MVHelper(model, surface);
        this.absoluteLowResValueChanger = absoluteLowResValueChanger;
        this.signedBitRelativeValueChanger = signedBitRelativeValueChanger;
        this.signedBit2RelativeValueChanger = signedBit2RelativeValueChanger;
        this.offsetBinaryRelativeValueChanger = offsetBinaryRelativeValueChanger;
    }

    protected IValueChanger getAbsoluteValueChanger(MidiValue value) {
        return value.isHighRes() ? this.model.getValueChanger() : this.absoluteLowResValueChanger;
    }

    protected IValueChanger getRelativeValueChanger(KnobMode knobMode) {
        switch (knobMode) {
            default: {
                return this.model.getValueChanger();
            }
            case RELATIVE_SIGNED_BIT: {
                return this.signedBitRelativeValueChanger;
            }
            case RELATIVE_SIGNED_BIT_2: {
                return this.signedBit2RelativeValueChanger;
            }
            case RELATIVE_OFFSET_BINARY: 
        }
        return this.offsetBinaryRelativeValueChanger;
    }

    protected boolean isIncrease(KnobMode knobMode, MidiValue control) {
        return this.getRelativeValueChanger(knobMode).calcKnobChange(control.getValue()) > 0.0;
    }

    public static boolean isAbsolute(KnobMode knobMode) {
        return knobMode == KnobMode.ABSOLUTE || knobMode == KnobMode.ABSOLUTE_TOGGLE;
    }

    protected boolean isButtonPressed(KnobMode knobMode, MidiValue value) {
        return knobMode == KnobMode.ABSOLUTE_TOGGLE || knobMode == KnobMode.ABSOLUTE && value.isPositive();
    }

    protected boolean increaseKnobMovement() {
        ++this.movementCounter;
        if (this.movementCounter < 6) {
            return false;
        }
        this.movementCounter = 0;
        return true;
    }

    protected static int toMidiValue(boolean state) {
        return state ? 16383 : 0;
    }
}

